/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RemoteDriverFactory {
    public WebDriver create(Config config, Browser browser, MutableCapabilities capabilities) {
        try {
            this.setupCapabilities(config, browser, capabilities);
            RemoteWebDriver webDriver = new RemoteWebDriver(new URL(config.remote()), (Capabilities)capabilities);
            webDriver.setFileDetector((FileDetector)new LocalFileDetector());
            return webDriver;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + config.remote(), e);
        }
    }

    protected void setupCapabilities(Config config, Browser browser, MutableCapabilities capabilities) {
        capabilities.setCapability("browserName", this.getBrowserNameForGrid(config, browser));
    }

    protected String getBrowserNameForGrid(Config config, Browser browser) {
        if (browser.isLegacyFirefox()) {
            return "firefox";
        }
        if (browser.isIE()) {
            return "internet explorer";
        }
        if (browser.isEdge()) {
            return "MicrosoftEdge";
        }
        if (browser.isOpera()) {
            return "operablink";
        }
        return config.browser();
    }
}

