/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.BrowserResizer;
import com.codeborne.selenide.webdriver.ChromeDriverFactory;
import com.codeborne.selenide.webdriver.DefaultDriverFactory;
import com.codeborne.selenide.webdriver.DriverFactory;
import com.codeborne.selenide.webdriver.EdgeDriverFactory;
import com.codeborne.selenide.webdriver.FirefoxDriverFactory;
import com.codeborne.selenide.webdriver.InternetExplorerDriverFactory;
import com.codeborne.selenide.webdriver.LegacyFirefoxDriverFactory;
import com.codeborne.selenide.webdriver.OperaDriverFactory;
import com.codeborne.selenide.webdriver.RemoteDriverFactory;
import com.codeborne.selenide.webdriver.SafariDriverFactory;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    protected Map<String, Class<? extends AbstractDriverFactory>> factories = this.factories();
    protected RemoteDriverFactory remoteDriverFactory = new RemoteDriverFactory();
    protected BrowserResizer browserResizer = new BrowserResizer();

    private Map<String, Class<? extends AbstractDriverFactory>> factories() {
        HashMap<String, Class<? extends AbstractDriverFactory>> result = new HashMap<String, Class<? extends AbstractDriverFactory>>();
        result.put("chrome", ChromeDriverFactory.class);
        result.put("legacy_firefox", LegacyFirefoxDriverFactory.class);
        result.put("firefox", FirefoxDriverFactory.class);
        result.put("edge", EdgeDriverFactory.class);
        result.put("internet explorer", InternetExplorerDriverFactory.class);
        result.put("ie", InternetExplorerDriverFactory.class);
        result.put("opera", OperaDriverFactory.class);
        result.put("safari", SafariDriverFactory.class);
        return result;
    }

    public WebDriver createWebDriver(Config config, Proxy proxy, File browserDownloadsFolder) {
        log.debug("browser={}", (Object)config.browser());
        log.debug("browser.version={}", (Object)config.browserVersion());
        log.debug("remote={}", (Object)config.remote());
        log.debug("browserSize={}", (Object)config.browserSize());
        log.debug("startMaximized={}", (Object)config.startMaximized());
        log.debug("downloadsFolder={}", (Object)browserDownloadsFolder.getAbsolutePath());
        Browser browser = new Browser(config.browser(), config.headless());
        WebDriver webdriver = this.createWebDriverInstance(config, proxy, browser, browserDownloadsFolder);
        this.browserResizer.adjustBrowserSize(config, webdriver);
        this.browserResizer.adjustBrowserPosition(config, webdriver);
        this.setLoadTimeout(config, webdriver);
        this.logBrowserVersion(webdriver);
        log.info("Selenide v. {}", (Object)SelenideDriver.class.getPackage().getImplementationVersion());
        this.logSeleniumInfo(config);
        return webdriver;
    }

    private void setLoadTimeout(Config config, WebDriver webdriver) {
        try {
            webdriver.manage().timeouts().pageLoadTimeout(config.pageLoadTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (UnsupportedCommandException e) {
            log.info("Failed to set page load timeout to {} ms: {}", (Object)config.pageLoadTimeout(), (Object)e.toString());
        }
        catch (RuntimeException e) {
            log.error("Failed to set page load timeout to {} ms", (Object)config.pageLoadTimeout(), (Object)e);
        }
    }

    private WebDriver createWebDriverInstance(Config config, Proxy proxy, Browser browser, File browserDownloadsFolder) {
        DriverFactory webdriverFactory = this.findFactory(browser);
        if (config.remote() != null) {
            MutableCapabilities capabilities = webdriverFactory.createCapabilities(config, browser, proxy, browserDownloadsFolder);
            return this.remoteDriverFactory.create(config, browser, capabilities);
        }
        if (config.driverManagerEnabled()) {
            webdriverFactory.setupWebdriverBinary();
        }
        return webdriverFactory.create(config, browser, proxy, browserDownloadsFolder);
    }

    private DriverFactory findFactory(Browser browser) {
        Class<DefaultDriverFactory> factoryClass = this.factories.getOrDefault(browser.name.toLowerCase(), DefaultDriverFactory.class);
        try {
            return (DriverFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to initialize " + factoryClass.getName(), e);
        }
    }

    protected void logSeleniumInfo(Config config) {
        if (config.remote() == null) {
            BuildInfo seleniumInfo = new BuildInfo();
            log.info("Selenium WebDriver v. {} build time: {}", (Object)seleniumInfo.getReleaseLabel(), (Object)seleniumInfo.getBuildTime());
        }
    }

    protected void logBrowserVersion(WebDriver webdriver) {
        if (webdriver instanceof HasCapabilities) {
            Capabilities capabilities = ((HasCapabilities)webdriver).getCapabilities();
            log.info("BrowserName={} Version={} Platform={}", new Object[]{capabilities.getBrowserName(), capabilities.getVersion(), capabilities.getPlatform()});
        } else {
            log.info("BrowserName={}", (Object)webdriver.getClass().getName());
        }
    }
}

