/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.drivercommands.BasicAuthUrl;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.codeborne.selenide.proxy.AuthenticationFilter;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.net.URL;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

@ParametersAreNonnullByDefault
public class Navigator {
    private static final Pattern ABSOLUTE_URL_REGEX = Pattern.compile("^[a-zA-Z-]+:.*", 32);
    private final BasicAuthUrl basicAuthUrl = new BasicAuthUrl();

    public void open(SelenideDriver driver, String relativeOrAbsoluteUrl) {
        this.navigateTo(driver, relativeOrAbsoluteUrl, AuthenticationType.BASIC, "", "", "");
    }

    public void open(SelenideDriver driver, URL url) {
        this.navigateTo(driver, url.toExternalForm(), AuthenticationType.BASIC, "", "", "");
    }

    public void open(SelenideDriver driver, String relativeOrAbsoluteUrl, String domain, String login, String password) {
        this.navigateTo(driver, relativeOrAbsoluteUrl, AuthenticationType.BASIC, domain, login, password);
    }

    public void open(SelenideDriver driver, URL url, String domain, String login, String password) {
        this.navigateTo(driver, url.toExternalForm(), AuthenticationType.BASIC, domain, login, password);
    }

    public void open(SelenideDriver driver, String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        this.navigateTo(driver, relativeOrAbsoluteUrl, authenticationType, "", credentials.login, credentials.password);
    }

    private AuthenticationFilter basicAuthRequestFilter(SelenideProxyServer selenideProxy) {
        return (AuthenticationFilter)selenideProxy.requestFilter("authentication");
    }

    @Nonnull
    String absoluteUrl(Config config, String relativeOrAbsoluteUrl) {
        return this.isAbsoluteUrl(relativeOrAbsoluteUrl) ? relativeOrAbsoluteUrl : config.baseUrl() + relativeOrAbsoluteUrl;
    }

    private void navigateTo(SelenideDriver driver, String relativeOrAbsoluteUrl, AuthenticationType authenticationType, String domain, String login, String password) {
        this.checkThatProxyIsEnabled(driver.config());
        String absoluteUrl = this.absoluteUrl(driver.config(), relativeOrAbsoluteUrl);
        String url = this.appendBasicAuthIfNeeded(driver.config(), absoluteUrl, authenticationType, domain, login, password);
        SelenideLogger.run("open", url, () -> {
            try {
                WebDriver webDriver = driver.getAndCheckWebDriver();
                this.beforeNavigateTo(driver.config(), driver.getProxy(), authenticationType, domain, login, password);
                webDriver.navigate().to(url);
            }
            catch (WebDriverException e) {
                e.addInfo("selenide.url", url);
                e.addInfo("selenide.baseUrl", driver.config().baseUrl());
                if (driver.config().remote() != null) {
                    e.addInfo("selenide.remote", driver.config().remote());
                }
                throw e;
            }
        });
    }

    public void open(SelenideDriver driver) {
        this.checkThatProxyIsEnabled(driver.config());
        SelenideLogger.run("open", "", driver::getAndCheckWebDriver);
    }

    private void checkThatProxyIsEnabled(Config config) {
        if (!config.proxyEnabled() && config.fileDownload() == FileDownloadMode.PROXY) {
            throw new IllegalStateException("config.proxyEnabled == false but config.fileDownload == PROXY. You need to enable proxy server automatically.");
        }
    }

    private void checkThatProxyIsStarted(@Nullable SelenideProxyServer selenideProxy) {
        if (selenideProxy == null) {
            throw new IllegalStateException("config.proxyEnabled == true but proxy server is not created. You need to call `setWebDriver(webDriver, selenideProxy)` instead of `setWebDriver(webDriver)` if you need to use proxy.");
        }
        if (!selenideProxy.isStarted()) {
            throw new IllegalStateException("config.proxyEnabled == true but proxy server is not started.");
        }
    }

    private void beforeNavigateTo(Config config, @Nullable SelenideProxyServer selenideProxy, AuthenticationType authenticationType, String domain, String login, String password) {
        if (config.proxyEnabled()) {
            this.checkThatProxyIsStarted(selenideProxy);
            this.beforeNavigateToWithProxy(selenideProxy, authenticationType, domain, login, password);
        } else {
            this.beforeNavigateToWithoutProxy(authenticationType, domain, login, password);
        }
    }

    private void beforeNavigateToWithProxy(SelenideProxyServer selenideProxy, AuthenticationType authenticationType, String domain, String login, String password) {
        if (this.hasAuthentication(domain, login, password)) {
            this.basicAuthRequestFilter(selenideProxy).setAuthentication(authenticationType, new Credentials(login, password));
        } else {
            this.basicAuthRequestFilter(selenideProxy).removeAuthentication();
        }
    }

    private void beforeNavigateToWithoutProxy(AuthenticationType authenticationType, String domain, String login, String password) {
        if (this.hasAuthentication(domain, login, password) && authenticationType != AuthenticationType.BASIC) {
            throw new UnsupportedOperationException("Cannot use " + (Object)((Object)authenticationType) + " authentication without proxy server");
        }
    }

    private boolean hasAuthentication(String domain, String login, String password) {
        return !domain.isEmpty() || !login.isEmpty() || !password.isEmpty();
    }

    private String appendBasicAuthIfNeeded(Config config, String url, AuthenticationType authType, String domain, String login, String password) {
        return this.passBasicAuthThroughUrl(config, authType, domain, login, password) ? this.basicAuthUrl.appendBasicAuthToURL(url, domain, login, password) : url;
    }

    private boolean passBasicAuthThroughUrl(Config config, AuthenticationType authenticationType, String domain, String login, String password) {
        return this.hasAuthentication(domain, login, password) && !config.proxyEnabled() && authenticationType == AuthenticationType.BASIC;
    }

    boolean isAbsoluteUrl(String relativeOrAbsoluteUrl) {
        return ABSOLUTE_URL_REGEX.matcher(relativeOrAbsoluteUrl).matches();
    }

    public void back(Driver driver) {
        SelenideLogger.run("back", "", () -> driver.getWebDriver().navigate().back());
    }

    public void forward(Driver driver) {
        SelenideLogger.run("forward", "", () -> driver.getWebDriver().navigate().forward());
    }

    public void refresh(Driver driver) {
        SelenideLogger.run("refresh", "", () -> driver.getWebDriver().navigate().refresh());
    }
}

