/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.FileContent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;

@ParametersAreNonnullByDefault
public class JavaScript {
    private final FileContent jsSource;

    public JavaScript(String jsFileName) {
        this.jsSource = new FileContent(jsFileName);
    }

    @Nonnull
    public <T> T execute(SearchContext context, Object ... arguments) {
        String js = "return " + this.jsSource.content();
        return (T)this.jsExecutor(context).executeScript(js, arguments);
    }

    private JavascriptExecutor jsExecutor(SearchContext context) {
        if (context instanceof JavascriptExecutor) {
            return (JavascriptExecutor)context;
        }
        if (context instanceof WrapsDriver) {
            return (JavascriptExecutor)((WrapsDriver)context).getWrappedDriver();
        }
        throw new IllegalArgumentException("Context is not JS-aware: " + context);
    }

    @Nullable
    public Object node(SearchContext context) {
        return context instanceof WebDriver ? null : context;
    }
}

