/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.ex.UIAssertionError;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ScreenShooter
extends TestWatcher {
    private static final Logger log = LoggerFactory.getLogger(ScreenShooter.class);
    public boolean captureSuccessfulTests;

    private ScreenShooter() {
    }

    @CheckReturnValue
    @Nonnull
    public static ScreenShooter failedTests() {
        return new ScreenShooter();
    }

    @Nonnull
    public ScreenShooter succeededTests() {
        this.captureSuccessfulTests = true;
        return this;
    }

    protected void starting(Description test) {
        Screenshots.startContext(test.getClassName(), test.getMethodName());
    }

    protected void succeeded(Description test) {
        if (this.captureSuccessfulTests) {
            log.info(Screenshots.saveScreenshotAndPageSource());
        }
    }

    protected void failed(Throwable e, Description description) {
        if (!(e instanceof UIAssertionError)) {
            log.info(Screenshots.saveScreenshotAndPageSource());
        }
    }

    protected void finished(Description description) {
        Screenshots.finishContext();
    }

    @Nonnull
    public ScreenShooter to(String folderWithScreenshots) {
        Configuration.reportsFolder = folderWithScreenshots;
        return this;
    }
}

