/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit;

import com.codeborne.selenide.logevents.SimpleReport;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

@ParametersAreNonnullByDefault
public class TextReport
extends TestWatcher {
    protected SimpleReport report = new SimpleReport();
    private boolean onFailedTest = true;
    private boolean onSucceededTest = true;

    @Nonnull
    public TextReport onFailedTest(boolean onFailedTest) {
        this.onFailedTest = onFailedTest;
        return this;
    }

    @Nonnull
    public TextReport onSucceededTest(boolean onSucceededTest) {
        this.onSucceededTest = onSucceededTest;
        return this;
    }

    protected void starting(Description description) {
        if (this.onFailedTest || this.onSucceededTest) {
            this.report.start();
        }
    }

    protected void succeeded(Description description) {
        if (this.onSucceededTest) {
            this.report.finish(description.getDisplayName());
        }
    }

    protected void failed(Throwable e, Description description) {
        if (this.onFailedTest) {
            this.report.finish(description.getDisplayName());
        }
    }

    protected void finished(Description description) {
        this.report.clean();
    }
}

