/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class RequestSizeWatchdog
implements RequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RequestSizeWatchdog.class);
    int threshold = 0x200000;

    @Nullable
    public HttpResponse filterRequest(HttpRequest request, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (contents.getBinaryContents().length > this.threshold) {
            log.warn("Too large request {}: {} bytes", (Object)messageInfo.getUrl(), (Object)contents.getBinaryContents().length);
            log.trace("Request content: {}", (Object)contents.getTextContents());
        }
        return null;
    }
}

