/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.internal.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class HttpClientTimeouts {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientTimeouts.class);
    public static Duration defaultConnectTimeout = Duration.ofMinutes(1L);
    public static Duration defaultReadTimeout = Duration.ofMinutes(2L);

    HttpClientTimeouts() {
    }

    public void setup(WebDriver webDriver) {
        this.setup(webDriver, defaultConnectTimeout, defaultReadTimeout);
    }

    public void setup(WebDriver webDriver, Duration connectTimeout, Duration readTimeout) {
        if (webDriver instanceof RemoteWebDriver) {
            try {
                this.setupTimeouts((RemoteWebDriver)webDriver, connectTimeout, readTimeout);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to setup Selenium HttpClient timeouts", e);
            }
        }
    }

    private void setupTimeouts(RemoteWebDriver webDriver, Duration connectTimeout, Duration readTimeout) throws Exception {
        CommandExecutor executor = webDriver.getCommandExecutor();
        if (executor instanceof HttpCommandExecutor) {
            this.setupTimeouts((HttpCommandExecutor)executor, connectTimeout, readTimeout);
        }
    }

    private void setupTimeouts(HttpCommandExecutor executor, Duration connectTimeout, Duration readTimeout) throws Exception {
        Field clientField = HttpCommandExecutor.class.getDeclaredField("client");
        clientField.setAccessible(true);
        HttpClient client = (HttpClient)clientField.get(executor);
        if (client instanceof OkHttpClient) {
            this.setupTimeouts((OkHttpClient)client, connectTimeout, readTimeout);
        }
    }

    private void setupTimeouts(OkHttpClient client, Duration connectTimeout, Duration readTimeout) throws Exception {
        Field okClientField = OkHttpClient.class.getDeclaredField("client");
        okClientField.setAccessible(true);
        Object okClient = okClientField.get(client);
        if (okClient instanceof okhttp3.OkHttpClient) {
            this.setupTimeouts((okhttp3.OkHttpClient)okClient, connectTimeout, readTimeout);
        }
    }

    private void setupTimeouts(okhttp3.OkHttpClient okClient, Duration connectTimeout, Duration readTimeout) throws Exception {
        int previousConnectTimeout = okClient.connectTimeoutMillis();
        int previousReadTimeout = okClient.readTimeoutMillis();
        this.setFieldValue(okClient, Arrays.asList("connectTimeout", "connectTimeoutMillis"), (int)connectTimeout.toMillis());
        this.setFieldValue(okClient, Arrays.asList("readTimeout", "readTimeoutMillis"), (int)readTimeout.toMillis());
        logger.info("Changed connectTimeout from {} to {}", (Object)previousConnectTimeout, (Object)okClient.connectTimeoutMillis());
        logger.info("Changed readTimeout from {} to {}", (Object)previousReadTimeout, (Object)okClient.readTimeoutMillis());
    }

    private <T> void setFieldValue(T object, List<String> fieldNames, Object fieldValue) throws Exception {
        NoSuchFieldException fieldNotFound = null;
        for (String fieldName : fieldNames) {
            try {
                Field field = object.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(object, fieldValue);
                return;
            }
            catch (NoSuchFieldException e) {
                fieldNotFound = e;
            }
        }
        if (fieldNotFound != null) {
            throw fieldNotFound;
        }
    }
}

