/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class InternetExplorerDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(InternetExplorerDriverFactory.class);

    @Override
    public void setupWebdriverBinary() {
        if (this.isSystemPropertyNotSet("webdriver.ie.driver")) {
            WebDriverManager.iedriver().setup();
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver create(Config config, Browser browser, @Nullable Proxy proxy, File browserDownloadsFolder) {
        InternetExplorerOptions options = this.createCapabilities(config, browser, proxy, browserDownloadsFolder);
        return new InternetExplorerDriver(options);
    }

    @CheckReturnValue
    @Nonnull
    public InternetExplorerOptions createCapabilities(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        MutableCapabilities capabilities = this.createCommonCapabilities(config, browser, proxy);
        InternetExplorerOptions options = new InternetExplorerOptions((Capabilities)capabilities);
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            log.warn("Changing browser binary not supported in InternetExplorer, setting will be ignored.");
        }
        return options;
    }
}

