/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Config;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;

@ParametersAreNonnullByDefault
public class RemoteDriverFactory {
    public WebDriver create(Config config, MutableCapabilities capabilities) {
        try {
            RemoteWebDriver webDriver = new RemoteWebDriver(new URL(config.remote()), (Capabilities)capabilities);
            webDriver.setFileDetector((FileDetector)new LocalFileDetector());
            return webDriver;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + config.remote(), e);
        }
    }
}

