/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.stateful;

import com.codepoetics.protonpack.stateful.StateMachine;
import com.codepoetics.protonpack.stateful.Transition;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ComposedStateMachine<S, I, O>
implements StateMachine<S, I, O> {
    private final Supplier<S> initialStateSupplier;
    private final BiFunction<S, I, Transition<S, O>> transitionFunction;
    private final Predicate<S> isTerminal;
    private final Function<S, Stream<O>> finisher;

    ComposedStateMachine(Supplier<S> initialStateSupplier, BiFunction<S, I, Transition<S, O>> transitionFunction, Predicate<S> isTerminal, Function<S, Stream<O>> finisher) {
        this.initialStateSupplier = initialStateSupplier;
        this.transitionFunction = transitionFunction;
        this.isTerminal = isTerminal;
        this.finisher = finisher;
    }

    @Override
    public S getInitialState() {
        return this.initialStateSupplier.get();
    }

    @Override
    public Transition<S, O> apply(S state, I input) {
        return this.transitionFunction.apply(state, input);
    }

    @Override
    public boolean isTerminal(S state) {
        return this.isTerminal.test(state);
    }

    @Override
    public Stream<O> finish(S finalState) {
        return this.finisher.apply(finalState);
    }
}

