/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.stateful;

import java.util.stream.Stream;

public final class Transition<S, O> {
    private final S newState;
    private final Stream<O> outputs;

    @SafeVarargs
    public static <S, O> Transition<S, O> to(S newState, O ... outputs) {
        return Transition.to(newState, Stream.of(outputs));
    }

    public static <S, O> Transition<S, O> to(S newState, Stream<O> outputs) {
        return new Transition<S, O>(newState, outputs);
    }

    private Transition(S newState, Stream<O> outputs) {
        this.newState = newState;
        this.outputs = outputs;
    }

    public S getNewState() {
        return this.newState;
    }

    public Stream<O> getOutputs() {
        return this.outputs;
    }
}

