/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;

class GroupRunsSpliterator<T>
implements Spliterator<List<T>> {
    private Spliterator<T> source;
    private Comparator<T> comparator;
    Optional<T> last = Optional.empty();

    public GroupRunsSpliterator(Spliterator<T> source, Comparator<T> comparator) {
        this.source = source;
        this.comparator = comparator;
    }

    @Override
    public boolean tryAdvance(Consumer<? super List<T>> action) {
        Box current = new Box();
        LinkedList<Object> neighbors = new LinkedList<Object>();
        Boolean runBroken = false;
        if (this.last.isPresent()) {
            neighbors.add(this.last.get());
        }
        while (this.source.tryAdvance((? super T i) -> {
            box.item = i;
        })) {
            if (!this.last.isPresent() || this.comparator.compare(current.item, this.last.get()) == 0) {
                neighbors.add(current.item);
            } else {
                runBroken = true;
            }
            this.last = Optional.of(current.item);
            if (!runBroken.booleanValue()) continue;
            action.accept(neighbors);
            return true;
        }
        if (!neighbors.isEmpty()) {
            action.accept(neighbors);
            this.last = Optional.empty();
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<List<T>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFFFAF;
    }

    class Box<Y> {
        public Y item;

        Box() {
        }
    }
}

