/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import java.util.ArrayList;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

class MergingSpliterator<T, O>
implements Spliterator<O> {
    private final Spliterator<T>[] sources;
    private final Supplier<O> unitSupplier;
    private final BiFunction<O, T, O> merger;

    public static <T, O> Spliterator<O> merging(Spliterator<T>[] sources, Supplier<O> unitSupplier, BiFunction<O, T, O> merger) {
        return new MergingSpliterator<T, O>(sources, unitSupplier, merger);
    }

    private MergingSpliterator(Spliterator<T>[] sources, Supplier<O> unitSupplier, BiFunction<O, T, O> merger) {
        this.sources = sources;
        this.unitSupplier = unitSupplier;
        this.merger = merger;
    }

    @Override
    public boolean tryAdvance(Consumer<? super O> action) {
        ArrayList mergeables = new ArrayList(this.sources.length);
        Stream.of(this.sources).forEach(s -> s.tryAdvance(mergeables::add));
        if (mergeables.isEmpty()) {
            return false;
        }
        O unit = this.unitSupplier.get();
        action.accept(mergeables.stream().reduce(unit, this.merger, (l1, l2) -> l1));
        return true;
    }

    @Override
    public Spliterator<O> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Stream.of(this.sources).map(Spliterator::estimateSize).max(Long::compare).orElse(0L);
    }

    @Override
    public int characteristics() {
        return 0;
    }
}

