/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import com.codepoetics.protonpack.Seq;
import com.codepoetics.protonpack.StreamUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Streamable<T>
extends Supplier<Stream<T>> {
    public static <T> Streamable<T> empty() {
        return Stream::empty;
    }

    public static <T> Streamable<T> of(Supplier<Stream<T>> streamable) {
        return streamable::get;
    }

    public static <T> Streamable<T> of(T ... items) {
        return () -> Stream.of(items);
    }

    public static <T> Streamable<T> of(Collection<T> collection) {
        return collection::stream;
    }

    public static <T> Streamable<T> of(Iterable<T> iterable) {
        return () -> StreamUtils.ofNullable(iterable);
    }

    public static <T> Streamable<T> of(Optional<T> optional) {
        return () -> StreamUtils.stream(optional);
    }

    @SafeVarargs
    public static <T> Streamable<T> ofAll(Streamable<T> ... streamables) {
        return () -> Stream.of(streamables).flatMap(Streamable::stream);
    }

    default public Stream<T> stream() {
        return (Stream)this.get();
    }

    default public Streamable<T> concat(Streamable<T> streamable) {
        return () -> Stream.concat(this.stream(), streamable.stream());
    }

    default public <T2> Streamable<T2> transform(Function<Stream<T>, Stream<T2>> transformer) {
        return () -> (Stream)transformer.apply(this.stream());
    }

    default public <T2> Streamable<T2> map(Function<? super T, ? extends T2> f) {
        return this.transform(s -> s.map(f));
    }

    default public <T2> Streamable<T2> flatMap(Function<? super T, Stream<? extends T2>> f) {
        return this.transform(s -> s.flatMap(f));
    }

    default public Streamable<T> filter(Predicate<? super T> predicate) {
        return this.transform(s -> s.filter(predicate));
    }

    default public Streamable<T> reject(Predicate<? super T> predicate) {
        return this.transform(s -> s.filter(predicate.negate()));
    }

    default public Streamable<T> sorted(Comparator<? super T> comparator) {
        return () -> this.stream().sorted(comparator);
    }

    default public Streamable<T> skip(long n) {
        return () -> this.stream().skip(n);
    }

    default public Streamable<T> limit(long n) {
        return () -> this.stream().limit(n);
    }

    default public void forEach(Consumer<T> action) {
        this.stream().forEach(action);
    }

    default public void forEachOrdered(Consumer<T> action) {
        this.stream().forEachOrdered(action);
    }

    default public <O> O collect(Collector<T, ?, O> collector) {
        return this.stream().collect(collector);
    }

    default public List<T> toList() {
        return this.collect(Collectors.toList());
    }

    default public Set<T> toSet() {
        return this.collect(Collectors.toSet());
    }

    default public <K> Map<K, T> toMap(Function<? super T, ? extends K> indexFunction) {
        return this.collect(Collectors.toMap(indexFunction, v -> v));
    }

    default public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return this.collect(Collectors.toMap(keyFunction, valueFunction));
    }

    default public T[] toArray(IntFunction<T[]> arrayConstructor) {
        return this.stream().toArray(arrayConstructor);
    }

    default public Seq<T> toSeq() {
        return Seq.of(this.stream());
    }

    default public <U> U reduce(U identity, BiFunction<U, T, U> accumulator, BinaryOperator<U> combiner) {
        return ((Stream)this.get()).reduce(identity, accumulator, combiner);
    }

    default public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return ((Stream)this.get()).reduce(accumulator);
    }

    default public T reduce(T identity, BinaryOperator<T> accumulator) {
        return ((Stream)this.get()).reduce(identity, accumulator);
    }
}

