/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import java.time.Duration;

public interface DistributedLock {
    public String getId();

    public boolean acquire();

    public boolean acquire(Duration var1);

    public boolean acquireForever();

    public boolean release();

    default public AcquireAndExecuteResult acquireAndExecute(Runnable action) {
        return AcquireAndExecuteResult.executeOnAcquired(this.acquire(), action, this::release);
    }

    default public AcquireAndExecuteResult acquireAndExecute(Duration duration, Runnable action) {
        return AcquireAndExecuteResult.executeOnAcquired(this.acquire(duration), action, this::release);
    }

    default public AcquireAndExecuteResult acquireForeverAndExecute(Runnable action) {
        return AcquireAndExecuteResult.executeOnAcquired(this.acquireForever(), action, this::release);
    }

    default public ReleaseAndExecuteResult releaseAndExecute(Runnable action) {
        return ReleaseAndExecuteResult.executeOnReleased(this.release(), action);
    }

    public static class ReleaseAndExecuteResult {
        private final boolean released;

        private static ReleaseAndExecuteResult executeOnReleased(boolean released, Runnable action) {
            if (released) {
                action.run();
            }
            return new ReleaseAndExecuteResult(released);
        }

        ReleaseAndExecuteResult(boolean released) {
            this.released = released;
        }

        boolean isReleased() {
            return this.released;
        }

        ReleaseAndExecuteResult onNotReleased(Runnable action) {
            if (!this.released) {
                action.run();
            }
            return this;
        }
    }

    public static class AcquireAndExecuteResult {
        private final boolean acquired;

        private static AcquireAndExecuteResult executeOnAcquired(boolean acquired, Runnable action, Runnable release) {
            if (acquired) {
                try {
                    action.run();
                }
                finally {
                    release.run();
                }
            }
            return new AcquireAndExecuteResult(acquired);
        }

        AcquireAndExecuteResult(boolean acquired) {
            this.acquired = acquired;
        }

        public boolean isAcquired() {
            return this.acquired;
        }

        AcquireAndExecuteResult onNotAcquired(Runnable action) {
            if (!this.acquired) {
                action.run();
            }
            return this;
        }
    }
}

