/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.LockDuration;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.OwnerId;
import com.coditory.sherlock.OwnerIdPolicy;
import com.coditory.sherlock.SherlockDefaults;
import java.time.Duration;
import java.util.function.Function;

public final class DistributedLockBuilder<T> {
    private LockId lockId;
    private LockCreator<T> lockCreator;
    private LockDuration duration = SherlockDefaults.DEFAULT_LOCK_DURATION;
    private OwnerIdPolicy ownerIdPolicy = SherlockDefaults.DEFAULT_OWNER_ID_POLICY;

    DistributedLockBuilder(LockCreator<T> lockCreator) {
        this.lockCreator = lockCreator;
    }

    <R> DistributedLockBuilder<R> withMappedLock(Function<T, R> lockMapper) {
        return new DistributedLockBuilder<Object>((lockId, duration, ownerId) -> {
            T lock = this.lockCreator.createLock(lockId, duration, ownerId);
            return lockMapper.apply(lock);
        });
    }

    public DistributedLockBuilder<T> withLockId(String lockId) {
        this.lockId = LockId.of(lockId);
        return this;
    }

    DistributedLockBuilder<T> withLockDuration(LockDuration duration) {
        this.duration = duration;
        return this;
    }

    public DistributedLockBuilder<T> withLockDuration(Duration duration) {
        return this.withLockDuration(LockDuration.of(duration));
    }

    public DistributedLockBuilder<T> withPermanentLockDuration() {
        this.duration = LockDuration.permanent();
        return this;
    }

    public DistributedLockBuilder<T> withOwnerId(String ownerId) {
        return this.withOwnerIdPolicy(OwnerIdPolicy.staticOwnerIdPolicy(ownerId));
    }

    public DistributedLockBuilder<T> withUniqueOwnerId() {
        return this.withOwnerIdPolicy(OwnerIdPolicy.uniqueOwnerIdPolicy());
    }

    public DistributedLockBuilder<T> withStaticUniqueOwnerId() {
        return this.withOwnerIdPolicy(OwnerIdPolicy.staticUniqueOwnerIdPolicy());
    }

    DistributedLockBuilder<T> withOwnerIdPolicy(OwnerIdPolicy ownerIdPolicy) {
        this.ownerIdPolicy = ownerIdPolicy;
        return this;
    }

    public T build() {
        return this.lockCreator.createLock(this.lockId, this.duration, this.ownerIdPolicy.getOwnerId());
    }

    @FunctionalInterface
    static interface LockCreator<T> {
        public T createLock(LockId var1, LockDuration var2, OwnerId var3);
    }
}

