/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.LockId;
import com.coditory.sherlock.OwnerId;
import com.mongodb.client.model.Filters;
import java.time.Instant;
import org.bson.conversions.Bson;

final class MongoDistributedLockQueries {
    private MongoDistributedLockQueries() {
        throw new IllegalStateException("Do not instantiate utility class");
    }

    static Bson queryReleased(LockId lockId, Instant now) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)lockId.getValue()), Filters.lte((String)"expiresAt", (Object)now)});
    }

    static Bson queryAcquired(LockId lockId, OwnerId ownerId) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)lockId.getValue()), Filters.eq((String)"acquiredBy", (Object)ownerId.getValue())});
    }

    static Bson queryAcquiredOrReleased(LockId lockId, OwnerId ownerId, Instant now) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)lockId.getValue()), Filters.or((Bson[])new Bson[]{Filters.eq((String)"acquiredBy", (Object)ownerId.getValue()), Filters.lte((String)"expiresAt", (Object)now)})});
    }

    static Bson queryById(LockId lockId) {
        return Filters.eq((String)"_id", (Object)lockId.getValue());
    }
}

