/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.api;

import com.comcast.drivethru.model.ResponseContainer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HTTPRequestManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPRequestManager.class);
    private String mUrl;
    private byte[] mData;
    private SSLConnectionSocketFactory mSocketFactory;
    private String mContentType;
    private Map.Entry<String, String> mAuth;
    private METHOD mMethod;
    private Map<String, String> mHeaders;
    private String[] mCookies;
    private String mUserAgent;

    private HTTPRequestManager(Builder builder) {
        this.mUrl = builder.mUrl;
        this.mData = builder.mData;
        this.mSocketFactory = builder.mSocketFactory;
        this.mContentType = builder.mContentType;
        this.mAuth = builder.mAuth;
        this.mMethod = builder.mMethod;
        this.mHeaders = builder.mHeaders;
        this.mUserAgent = builder.mUserAgent;
        this.mCookies = builder.mCookies;
        if (this.mUrl == null) {
            throw new IllegalStateException("URL is a required field");
        }
        if (this.mMethod == null) {
            throw new IllegalStateException("Method is a required field");
        }
    }

    private CloseableHttpClient createHttpClient() {
        CloseableHttpClient client = null;
        client = this.mSocketFactory != null && this.mUrl.startsWith("https") ? HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.mSocketFactory).build() : HttpClients.custom().build();
        return client;
    }

    private void setHeaders(HttpUriRequest message) {
        if (this.mCookies != null) {
            for (String cookie : this.mCookies) {
                message.addHeader("Cookie", cookie);
            }
        }
        if (this.mContentType != null && !this.mContentType.isEmpty()) {
            message.setHeader("Content-Type", this.mContentType);
        }
        if (this.mUserAgent != null && !this.mUserAgent.isEmpty()) {
            message.setHeader("User-Agent", this.mUserAgent);
        }
        for (String key : this.mHeaders.keySet()) {
            message.setHeader(key, this.mHeaders.get(key));
        }
        if (this.mAuth != null) {
            message.setHeader(this.mAuth.getKey(), this.mAuth.getValue());
        }
    }

    private HttpUriRequest createMethod() {
        HttpGet request = null;
        switch (this.mMethod) {
            case GET: {
                request = new HttpGet(this.mUrl);
                break;
            }
            case POST: {
                request = new HttpPost(this.mUrl);
                break;
            }
            case PATCH: {
                request = new HttpPatch(this.mUrl);
                break;
            }
            case OPTIONS: {
                request = new HttpOptions(this.mUrl);
                break;
            }
            case DELETE: {
                request = new HttpDelete(this.mUrl);
                break;
            }
            case PUT: {
                request = new HttpPut(this.mUrl);
                break;
            }
            case HEAD: {
                request = new HttpHead(this.mUrl);
                break;
            }
            case TRACE: {
                request = new HttpTrace(this.mUrl);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown method: " + this.mMethod.toString());
            }
        }
        return request;
    }

    public ResponseContainer sendRequest() throws IOException {
        HttpUriRequest httpMethod = this.createMethod();
        CloseableHttpClient client = this.createHttpClient();
        this.setHeaders(httpMethod);
        ResponseContainer container = null;
        container = this.mData != null && this.mData.length > 0 ? this.sendRequestWithData(client, httpMethod) : this.sendRequest(client, httpMethod);
        return container;
    }

    private ResponseContainer sendRequestWithData(CloseableHttpClient client, HttpUriRequest request) throws IOException {
        HttpEntityEnclosingRequestBase httpMethod = (HttpEntityEnclosingRequestBase)request;
        ByteArrayEntity entity = new ByteArrayEntity(this.mData);
        httpMethod.setEntity((HttpEntity)entity);
        return this.sendRequest(client, httpMethod);
    }

    private ResponseContainer sendRequest(CloseableHttpClient client, Object request) throws IOException {
        ResponseContainer responseContainer = null;
        try {
            CloseableHttpResponse response = null;
            LOGGER.info("Sending request to " + this.mUrl);
            response = request instanceof HttpEntityEnclosingRequestBase ? client.execute((HttpUriRequest)((HttpEntityEnclosingRequestBase)request)) : client.execute((HttpUriRequest)request);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
            Header[] headers = response.getAllHeaders();
            String responseLog = "Response: " + responseCode + " - ";
            if (responseText != null) {
                responseLog = responseLog + responseText;
            }
            if (responseCode == 200) {
                LOGGER.info(responseLog);
            } else {
                LOGGER.error(responseLog);
            }
            responseContainer = new ResponseContainer(responseCode, responseText, headers);
        }
        catch (IOException e) {
            throw new IOException("Connection failed. Request not sent");
        }
        finally {
            client.close();
        }
        return responseContainer;
    }

    public static class Builder {
        private static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded";
        private static final METHOD DEFAULT_METHOD = METHOD.GET;
        private static final String DEFAULT_ENCODING = "UTF-8";
        private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
        private String mContentType = "application/x-www-form-urlencoded";
        private Map.Entry<String, String> mAuth;
        private String mUrl;
        private METHOD mMethod = DEFAULT_METHOD;
        private Map<String, String> mHeaders = DEFAULT_HEADERS;
        private SSLConnectionSocketFactory mSocketFactory = null;
        private byte[] mData;
        private String mUserAgent;
        private String[] mCookies;

        public Builder userAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public Builder cookies(String[] cookies) {
            this.mCookies = cookies;
            return this;
        }

        public Builder data(String data) {
            this.mData = data.getBytes();
            return this;
        }

        public Builder data(byte[] data) {
            this.mData = data;
            return this;
        }

        public Builder url(String url) {
            this.mUrl = url;
            return this;
        }

        public Builder auth(Map.Entry<String, String> auth) {
            this.mAuth = auth;
            return this;
        }

        public Builder contentType(String contentType) {
            this.mContentType = contentType;
            return this;
        }

        public Builder method(String method) {
            if (method.equals("GET")) {
                this.mMethod = METHOD.GET;
            } else if (method.equals("POST")) {
                this.mMethod = METHOD.POST;
            } else if (method.equals("PATCH")) {
                this.mMethod = METHOD.PATCH;
            } else if (method.equals("OPTION")) {
                this.mMethod = METHOD.OPTIONS;
            } else if (method.equals("DELETE")) {
                this.mMethod = METHOD.DELETE;
            } else if (method.equals("PUT")) {
                this.mMethod = METHOD.PUT;
            } else if (method.equals("HEAD")) {
                this.mMethod = METHOD.HEAD;
            } else if (method.equals("TRACE")) {
                this.mMethod = METHOD.TRACE;
            }
            return this;
        }

        public Builder method(METHOD method) {
            this.mMethod = method;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.mHeaders = headers;
            return this;
        }

        public Builder socketFactory(SSLConnectionSocketFactory socketFactory) {
            this.mSocketFactory = socketFactory;
            return this;
        }

        public HTTPRequestManager build() {
            return new HTTPRequestManager(this);
        }

        static {
            DEFAULT_HEADERS.put("Accept-Language", "en-US,en;q=0.5");
            DEFAULT_HEADERS.put("accept-charset", DEFAULT_ENCODING);
        }
    }

    public static enum METHOD {
        GET,
        POST,
        PATCH,
        OPTIONS,
        DELETE,
        PUT,
        HEAD,
        TRACE;

    }
}

