/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.client;

import com.comcast.drivethru.RestClient;
import com.comcast.drivethru.exception.HttpException;
import com.comcast.drivethru.exception.HttpStatusException;
import com.comcast.drivethru.security.SecurityProvider;
import com.comcast.drivethru.transform.JsonTransformer;
import com.comcast.drivethru.transform.Transformer;
import com.comcast.drivethru.utils.Method;
import com.comcast.drivethru.utils.RestRequest;
import com.comcast.drivethru.utils.RestResponse;
import com.comcast.drivethru.utils.URL;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class DefaultRestClient
implements RestClient {
    private String defaultBaseUrl;
    private Transformer transformer;
    private HttpClient delegate;
    private SecurityProvider securityProvider;
    private Map<String, String> defaultHeaders;

    public DefaultRestClient() {
        this(null);
    }

    private static HttpClient defaultClient() {
        return HttpClientBuilder.create().setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(10000).build()).build();
    }

    public DefaultRestClient(String defaultBaseUrl) {
        this(defaultBaseUrl, new JsonTransformer());
    }

    public DefaultRestClient(String defaultBaseUrl, Transformer transformer) {
        this(defaultBaseUrl, transformer, DefaultRestClient.defaultClient());
    }

    public DefaultRestClient(String defaultBaseUrl, HttpClient delegate) {
        this(defaultBaseUrl, new JsonTransformer(), delegate);
    }

    public DefaultRestClient(String defaultBaseUrl, Transformer transformer, HttpClient delegate) {
        this.defaultBaseUrl = defaultBaseUrl;
        this.transformer = transformer;
        this.delegate = delegate;
        this.securityProvider = null;
        this.defaultHeaders = new HashMap<String, String>();
    }

    @Override
    public String getDefaultBaseUrl() {
        return this.defaultBaseUrl;
    }

    @Override
    public void addDefaultHeader(String name, String value) {
        this.defaultHeaders.put(name, value);
    }

    @Override
    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RestResponse execute(RestRequest request) throws HttpException {
        RestResponse restResponse;
        String url = request.getUrl().setDefaultBaseUrl(this.defaultBaseUrl).build();
        Method method = request.getMethod();
        HttpRequestBase req = method.getRequest(url);
        req.setConfig(request.getConfig());
        byte[] payload = request.getBody();
        if (null != payload) {
            if (!(req instanceof HttpEntityEnclosingRequest)) {
                throw new HttpException("Cannot attach a body to a " + method.name() + " request");
            }
            ByteArrayEntity entity = new ByteArrayEntity(payload);
            ((HttpEntityEnclosingRequest)req).setEntity((HttpEntity)entity);
        }
        for (Map.Entry<String, String> pair : this.defaultHeaders.entrySet()) {
            req.addHeader(pair.getKey(), pair.getValue());
        }
        for (Map.Entry<String, String> pair : request.getHeaders().entrySet()) {
            req.addHeader(pair.getKey(), pair.getValue());
        }
        if (null != this.securityProvider) {
            this.securityProvider.sign((HttpUriRequest)req);
        }
        InputStream in = null;
        ByteArrayOutputStream baos = null;
        try {
            HttpResponse resp = this.delegate.execute((HttpUriRequest)req);
            RestResponse response = new RestResponse(resp.getStatusLine());
            response.addAll(resp.getAllHeaders());
            HttpEntity body = resp.getEntity();
            if (null != body) {
                in = body.getContent();
                baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)baos);
                response.setBody(baos.toByteArray());
            }
            restResponse = response;
        }
        catch (RuntimeException ex) {
            try {
                req.abort();
                throw ex;
                catch (HttpResponseException hrex) {
                    throw new HttpStatusException(hrex.getStatusCode());
                }
                catch (ClientProtocolException cpex) {
                    throw new HttpException("HTTP Protocol error occurred.", cpex);
                }
                catch (IOException ioex) {
                    throw new HttpException("Error establishing connection.", ioex);
                }
            }
            catch (Throwable throwable) {
                req.abort();
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(baos);
                throw throwable;
            }
        }
        req.abort();
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)baos);
        return restResponse;
    }

    @Override
    public <T> T get(String path, Class<T> type) throws HttpException {
        return this.get(new URL().setPath(path), type);
    }

    @Override
    public <T> T get(URL url, Class<T> type) throws HttpException {
        RestRequest request = new RestRequest(url, Method.GET);
        RestResponse response = this.execute(request);
        if (response.getStatusCode() != 200) {
            throw new HttpStatusException(response.getStatusCode(), response.getStatusMessage());
        }
        String contentType = response.getContentType();
        if (contentType != null && contentType.equals(this.transformer.getMime())) {
            byte[] body = response.getBody();
            return this.transformer.read(body, type);
        }
        throw new HttpException("Invalid Content Type: " + contentType);
    }

    @Override
    public <T> boolean put(String path, T t) throws HttpException {
        return this.put(new URL().setPath(path), t);
    }

    @Override
    public <T> boolean put(URL url, T t) throws HttpException {
        RestRequest request = new RestRequest(url, Method.PUT);
        request.setContentType(this.transformer.getMime());
        request.setBody(this.transformer.write(t));
        RestResponse response = this.execute(request);
        switch (response.getStatusCode()) {
            case 201: {
                return true;
            }
            case 200: 
            case 204: {
                return false;
            }
        }
        throw new HttpStatusException(response.getStatusCode(), response.getStatusMessage());
    }

    @Override
    public boolean delete(String path) throws HttpException {
        return this.delete(new URL().setPath(path));
    }

    @Override
    public boolean delete(URL url) throws HttpException {
        RestRequest request = new RestRequest(url, Method.DELETE);
        RestResponse response = this.execute(request);
        switch (response.getStatusCode()) {
            case 200: {
                return true;
            }
            case 202: 
            case 204: {
                return false;
            }
        }
        throw new HttpStatusException(response.getStatusCode(), response.getStatusMessage());
    }

    @Override
    public <T> T post(String path, Class<T> responseType) throws HttpException {
        return this.post(path, null, responseType);
    }

    @Override
    public <T> T post(URL url, Class<T> responseType) throws HttpException {
        return this.post(url, null, responseType);
    }

    @Override
    public <P, T> T post(String path, P payload, Class<T> responseType) throws HttpException {
        return this.post(new URL().setPath(path), payload, responseType);
    }

    @Override
    public <P, T> T post(URL url, P payload, Class<T> responseType) throws HttpException {
        RestRequest request = new RestRequest(url, Method.POST);
        if (null != payload) {
            request.setContentType(this.transformer.getMime());
            request.setBody(this.transformer.write(payload));
        }
        RestResponse response = this.execute(request);
        switch (response.getStatusCode()) {
            case 200: 
            case 201: 
            case 204: {
                break;
            }
            default: {
                throw new HttpStatusException(response.getStatusCode(), response.getStatusMessage());
            }
        }
        if (responseType.equals(Void.TYPE)) {
            return null;
        }
        String contentType = response.getContentType();
        if (contentType != null && contentType.equals(this.transformer.getMime())) {
            byte[] body = response.getBody();
            return this.transformer.read(body, responseType);
        }
        throw new HttpException("Invalid Content Type: " + contentType);
    }

    @Override
    public void close() throws IOException {
        HttpClientUtils.closeQuietly((HttpClient)this.delegate);
    }
}

