/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.security;

import com.comcast.drivethru.exception.HttpException;
import com.comcast.drivethru.security.SecurityProvider;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.apache.http.client.methods.HttpUriRequest;

public class OAuthSecurityProvider
implements SecurityProvider {
    private OAuthConsumer consumer;

    public OAuthSecurityProvider(String key, String secret) {
        this((OAuthConsumer)new CommonsHttpOAuthConsumer(key, secret));
    }

    public OAuthSecurityProvider(OAuthConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public synchronized void sign(HttpUriRequest request) throws HttpException {
        try {
            this.consumer.sign((Object)request);
        }
        catch (OAuthException oaex) {
            throw new HttpException("OAUTH failed to secure request", oaex);
        }
    }
}

