/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.spring;

import com.comcast.cereal.CerealException;
import com.comcast.cereal.engines.CerealEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;

public class AbstractCerealHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private CerealEngine engine;

    public AbstractCerealHttpMessageConverter(CerealEngine engine, MediaType mediaType) {
        super(mediaType);
        this.engine = engine;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(inputMessage.getBody());
            Object object = this.engine.read((Reader)reader, clazz);
            return object;
        }
        catch (CerealException cex) {
            throw new IOException("Failed to decerealize the content", cex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputMessage.getBody());
        }
    }

    public void writeInternal(Object t, HttpOutputMessage outputMessage) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody());
            this.engine.write(t, (Writer)writer);
            ((Writer)writer).close();
        }
        catch (CerealException cex) {
            throw new IOException("Failed to cerealize the content", cex);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputMessage.getBody());
        }
    }
}

