/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.spring;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class ExceptionHandler
implements HandlerExceptionResolver,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandler.class);
    private int defaultResponse = 500;
    private String viewName = "error.html";
    private Map<Class<? extends Exception>, Integer> exceptionMap = null;

    public void setDefaultResponse(int defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    public int getDefaultResponse() {
        return this.defaultResponse;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setExceptionMap(Map<Class<? extends Exception>, Integer> exceptionMap) {
        this.exceptionMap = exceptionMap;
    }

    public Map<Class<? extends Exception>, Integer> getExceptionMap() {
        return this.exceptionMap;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LOGGER.error("Exception thrown by controller: ", (Throwable)ex);
        HttpStatus status = null;
        String reason = null;
        Class<?> clazz = ex.getClass();
        ResponseStatus responseStatus = clazz.getAnnotation(ResponseStatus.class);
        if (null != responseStatus) {
            status = responseStatus.value();
            reason = responseStatus.reason();
        } else if (null != this.exceptionMap) {
            for (Map.Entry<Class<? extends Exception>, Integer> entry : this.exceptionMap.entrySet()) {
                if (!entry.getKey().isAssignableFrom(clazz)) continue;
                status = HttpStatus.valueOf((int)entry.getValue());
                break;
            }
        }
        if (null == status) {
            status = HttpStatus.valueOf((int)this.defaultResponse);
        }
        if (null == reason || "".equals(reason)) {
            reason = status.getReasonPhrase();
        }
        response.setStatus(status.value());
        ModelAndView mav = new ModelAndView(this.viewName);
        mav.addObject("status", (Object)status.value());
        mav.addObject("reason", (Object)reason);
        mav.addObject("exception", (Object)ex);
        return mav;
    }
}

