/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.test;

import com.comcast.cereal.CerealException;
import com.comcast.cereal.engines.JsonCerealEngine;
import com.comcast.drivethru.exception.HttpException;
import com.comcast.drivethru.utils.Method;
import com.comcast.drivethru.utils.RestResponse;

public class ResponseBuilder {
    private String pattern;
    private boolean regex;
    private Method method;
    private int times;
    private RestResponse response;
    private HttpException exception;
    private long delay;

    public ResponseBuilder() {
        this(null, ".*", true);
    }

    public ResponseBuilder(String pattern) {
        this(null, pattern, true);
    }

    public ResponseBuilder(String pattern, boolean regex) {
        this(null, pattern, regex);
    }

    public ResponseBuilder(Method method) {
        this(method, ".*", true);
    }

    public ResponseBuilder(Method method, String pattern) {
        this(method, pattern, true);
    }

    public ResponseBuilder(Method method, String pattern, boolean regex) {
        this.pattern = pattern;
        this.regex = regex;
        this.method = method;
        this.times = -1;
        this.response = null;
        this.exception = null;
        this.delay = -1L;
    }

    public boolean matches(String url, Method method) {
        if (this.times == 0) {
            return false;
        }
        if (null != this.method && !this.method.equals((Object)method)) {
            return false;
        }
        if (this.regex) {
            return url.matches(this.pattern);
        }
        return this.pattern.equals(url);
    }

    public RestResponse replay() throws HttpException {
        --this.times;
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException iex) {
                Thread.interrupted();
            }
        }
        if (null != this.exception) {
            throw this.exception;
        }
        return this.response;
    }

    public ResponseBuilder after(long delay) {
        this.delay = delay;
        return this;
    }

    public ResponseBuilder andThrow(HttpException exception) {
        this.exception = exception;
        return this;
    }

    public HttpException getException() {
        return this.exception;
    }

    public ResponseBuilder andReturn(int statusCode) {
        return this.andReturn(statusCode, "NOT_DEFINED");
    }

    public ResponseBuilder andReturn(int statusCode, String statusMessage) {
        this.response = new RestResponse(statusCode, statusMessage);
        return this;
    }

    public ResponseBuilder withBody(byte[] body, String contentType) {
        this.response.setBody(body);
        this.response.addHeader("Content-Type", contentType);
        return this;
    }

    public ResponseBuilder withBody(String body, String contentType) {
        return this.withBody(body.getBytes(), contentType);
    }

    public ResponseBuilder withJsonBody(Object object) throws CerealException {
        JsonCerealEngine jsonEngine = new JsonCerealEngine();
        return this.withBody(jsonEngine.writeToString(object), "application/json");
    }

    public ResponseBuilder withHeader(String name, String value) {
        this.response.addHeader(name, value);
        return this;
    }

    public ResponseBuilder once() {
        return this.times(1);
    }

    public ResponseBuilder times(int count) {
        this.times = count;
        return this;
    }
}

