/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.transform;

import com.comcast.cereal.CerealException;
import com.comcast.cereal.engines.CerealEngine;
import com.comcast.drivethru.exception.HttpException;
import com.comcast.drivethru.transform.StringTransformer;

public abstract class CerealTransformer
extends StringTransformer {
    private CerealEngine engine;

    public CerealTransformer(CerealEngine engine) {
        this.engine = engine;
    }

    @Override
    public <T> T readString(String s, Class<T> type) throws HttpException {
        try {
            return (T)this.engine.readFromString(s, type);
        }
        catch (CerealException cex) {
            throw new HttpException("Failed to deserialize from string", cex);
        }
    }

    @Override
    public <T> String writeString(T t) throws HttpException {
        try {
            return this.engine.writeToString(t);
        }
        catch (CerealException cex) {
            throw new HttpException("Failed to serialize object to string", cex);
        }
    }
}

