/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;

public class ResponseContainer {
    private int mStatusCode;
    private String mResponse;
    private Header[] mHeaders;

    public ResponseContainer(int statusCode) {
        this(statusCode, null, null);
    }

    public ResponseContainer(String response) {
        this(0, response, null);
    }

    public ResponseContainer(Header[] headers) {
        this(0, null, headers);
    }

    public ResponseContainer(int statusCode, String response, Header[] headers) {
        this.mStatusCode = statusCode;
        this.mResponse = response;
        this.mHeaders = headers;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    protected void setStatusCode(int statusCode) {
        this.mStatusCode = statusCode;
    }

    public String getResponseBody() {
        return this.mResponse;
    }

    protected void setResponseBody(String responseBody) {
        this.mResponse = responseBody;
    }

    public Header[] getResponseHeaders() {
        return this.mHeaders;
    }

    protected void setResponseHeaders(Header[] responseHeaders) {
        this.mHeaders = responseHeaders;
    }

    public List<String> getCookies() {
        ArrayList<String> cookies = new ArrayList<String>();
        for (Header h : this.mHeaders) {
            if (!h.getName().equalsIgnoreCase("set-cookie")) continue;
            cookies.add(h.getValue());
        }
        return cookies;
    }
}

