/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.utils;

import com.comcast.drivethru.exception.HttpException;
import java.lang.reflect.Constructor;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

public enum Method {
    GET(HttpGet.class),
    POST(HttpPost.class),
    PUT(HttpPut.class),
    DELETE(HttpDelete.class);

    private Class<? extends HttpRequestBase> type;

    private Method(Class<? extends HttpRequestBase> type) {
        this.type = type;
    }

    public HttpRequestBase getRequest(String url) throws HttpException {
        try {
            Constructor<? extends HttpRequestBase> constructor = this.type.getConstructor(String.class);
            return constructor.newInstance(url);
        }
        catch (Exception ex) {
            throw new HttpException("Failed to create an RestRequest", ex);
        }
    }
}

