/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.utils;

import com.comcast.drivethru.utils.Method;
import com.comcast.drivethru.utils.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;

public class RestRequest {
    private URL url;
    private Method method;
    private Map<String, String> headers;
    private byte[] body;
    private RequestConfig config = null;
    private RequestConfig.Builder configBuilder = RequestConfig.custom();

    public RestRequest(String path, Method method) {
        this(new URL().setPath(path), method);
    }

    public RestRequest(URL url, Method method) {
        this.url = url;
        this.method = method;
        this.headers = new HashMap<String, String>();
        this.body = null;
    }

    public URL getUrl() {
        return this.url;
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void addQuery(String key, String value) {
        this.url.addQuery(key, value);
    }

    public void setContentType(String type) {
        this.headers.put("Content-Type", type);
    }

    public void setBody(String body) {
        this.body = body.getBytes();
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setTimeout(int timeout) {
        this.configBuilder.setSocketTimeout(timeout);
    }

    public void setRedirectsEnabled(boolean redirectsEnabled) {
        this.configBuilder.setRedirectsEnabled(redirectsEnabled);
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public RequestConfig getConfig() {
        if (this.config != null) {
            return this.config;
        }
        return this.configBuilder.build();
    }
}

