/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.StatusLine;

public class RestResponse {
    private int statusCode;
    private String statusMessage;
    private Map<String, String> headers;
    private byte[] body;

    public RestResponse(StatusLine status) {
        this(status.getStatusCode(), status.getReasonPhrase());
    }

    public RestResponse(int statusCode, String statusMessage) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = new HashMap<String, String>();
        this.body = null;
    }

    public void addAll(Header ... headers) {
        for (Header header : headers) {
            this.headers.put(header.getName(), header.getValue());
        }
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getContentType() {
        String value = this.headers.get("Content-Type");
        if (value == null) {
            return null;
        }
        int index = value.indexOf(59);
        return -1 == index ? value : value.substring(0, index);
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyString() {
        return new String(this.body);
    }
}

