/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.drivethru.utils;

import com.comcast.drivethru.exception.HttpException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class URL {
    private String baseUrl;
    private String path;
    private List<String[]> query;

    public URL() {
        this(null);
    }

    public URL(String baseUrl) {
        this(baseUrl, null);
    }

    public URL(String baseUrl, String path) {
        this.baseUrl = baseUrl;
        this.path = path;
        this.query = new ArrayList<String[]>();
    }

    public URL setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public URL setDefaultBaseUrl(String defaultBaseUrl) {
        if (null == this.baseUrl) {
            this.baseUrl = defaultBaseUrl;
        }
        return this;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean hasBaseUrl() {
        return null != this.baseUrl;
    }

    public URL setPath(String path) {
        this.path = path;
        return this;
    }

    public URL addPath(String path) {
        this.path = null == this.path ? "/" + path : this.path + "/" + path;
        return this;
    }

    public URL addQuery(String key, Object value) {
        return this.addQuery(key, value.toString());
    }

    public URL addQuery(String key, String value) {
        String[] pair = new String[]{URL.encode(key), URL.encode(value)};
        this.query.add(pair);
        return this;
    }

    public String build() throws HttpException {
        if (null == this.baseUrl) {
            throw new HttpException("URL must set a baseUrl");
        }
        StringBuilder sb = new StringBuilder(this.baseUrl);
        if (null != this.path) {
            if (this.baseUrl.endsWith("/")) {
                int index;
                for (index = 0; index < this.path.length() && this.path.charAt(index) == '/'; ++index) {
                }
                sb.append(this.path.substring(index));
            } else {
                sb.append(this.path);
            }
        }
        if (this.query.size() > 0) {
            String[] pair = this.query.get(0);
            sb.append('?');
            sb.append(pair[0]);
            sb.append('=');
            sb.append(pair[1]);
        }
        for (int i = 1; i < this.query.size(); ++i) {
            String[] pair = this.query.get(i);
            sb.append('&');
            sb.append(pair[0]);
            sb.append('=');
            sb.append(pair[1]);
        }
        return sb.toString();
    }

    public static String encode(String val) {
        try {
            return URLEncoder.encode(val, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException ueex) {
            throw new RuntimeException("UTF-8 not supported on this machine", ueex);
        }
    }
}

