/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.jms.endpoint.JmsConsumer;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.jms.endpoint.JmsProducer;
import com.consol.citrus.jms.endpoint.JmsTopicSubscriber;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.messaging.SelectiveConsumer;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class JmsEndpoint
extends AbstractEndpoint
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private JmsProducer jmsProducer;
    private JmsConsumer jmsConsumer;
    private ApplicationContext applicationContext;

    public JmsEndpoint() {
        super((EndpointConfiguration)new JmsEndpointConfiguration());
    }

    public JmsEndpoint(JmsEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public SelectiveConsumer createConsumer() {
        if (this.jmsConsumer == null) {
            if (this.getEndpointConfiguration().isAutoStart()) {
                TestContextFactory testContextFactory = Optional.ofNullable(this.applicationContext).map(context -> (TestContextFactory)context.getBean(TestContextFactory.class)).orElse(TestContextFactory.newInstance());
                JmsTopicSubscriber jmsTopicSubscriber = new JmsTopicSubscriber(this.getSubscriberName(), this.getEndpointConfiguration(), testContextFactory);
                this.jmsConsumer = jmsTopicSubscriber;
                jmsTopicSubscriber.start();
            } else {
                this.jmsConsumer = new JmsConsumer(this.getConsumerName(), this.getEndpointConfiguration());
            }
        }
        return this.jmsConsumer;
    }

    public Producer createProducer() {
        if (this.jmsProducer == null) {
            this.jmsProducer = new JmsProducer(this.getProducerName(), this.getEndpointConfiguration());
        }
        return this.jmsProducer;
    }

    protected String getSubscriberName() {
        return this.getName() + ":subscriber";
    }

    public JmsEndpointConfiguration getEndpointConfiguration() {
        return (JmsEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void destroy() throws Exception {
        if (this.jmsConsumer instanceof JmsTopicSubscriber) {
            ((JmsTopicSubscriber)this.jmsConsumer).stop();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getEndpointConfiguration().isAutoStart()) {
            Assert.isTrue((boolean)this.getEndpointConfiguration().isPubSubDomain(), (String)"Invalid endpoint configuration - caching subscriber enabled but pubSubDomain is set to false - please enable pubSubDomain, too");
            this.createConsumer();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

