/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.endpoint.AbstractEndpointBuilder;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.jms.endpoint.JmsEndpoint;
import com.consol.citrus.jms.message.JmsMessageConverter;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.DestinationResolver;

public class JmsEndpointBuilder
extends AbstractEndpointBuilder<JmsEndpoint> {
    private JmsEndpoint endpoint = new JmsEndpoint();

    protected JmsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public JmsEndpointBuilder destination(String destinationName) {
        this.endpoint.getEndpointConfiguration().setDestinationName(destinationName);
        return this;
    }

    public JmsEndpointBuilder destination(Destination destination) {
        this.endpoint.getEndpointConfiguration().setDestination(destination);
        return this;
    }

    public JmsEndpointBuilder connectionFactory(ConnectionFactory connectionFactory) {
        this.endpoint.getEndpointConfiguration().setConnectionFactory(connectionFactory);
        return this;
    }

    public JmsEndpointBuilder jmsTemplate(JmsTemplate jmsTemplate) {
        this.endpoint.getEndpointConfiguration().setJmsTemplate(jmsTemplate);
        return this;
    }

    public JmsEndpointBuilder messageConverter(JmsMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public JmsEndpointBuilder destinationResolver(DestinationResolver resolver) {
        this.endpoint.getEndpointConfiguration().setDestinationResolver(resolver);
        return this;
    }

    public JmsEndpointBuilder destinationNameResolver(EndpointUriResolver resolver) {
        this.endpoint.getEndpointConfiguration().setDestinationNameResolver(resolver);
        return this;
    }

    public JmsEndpointBuilder pubSubDomain(boolean pubSubDomain) {
        this.endpoint.getEndpointConfiguration().setPubSubDomain(pubSubDomain);
        return this;
    }

    public JmsEndpointBuilder autoStart(boolean autoStart) {
        this.endpoint.getEndpointConfiguration().setAutoStart(autoStart);
        return this;
    }

    public JmsEndpointBuilder durableSubscription(boolean durableSubscription) {
        this.endpoint.getEndpointConfiguration().setDurableSubscription(durableSubscription);
        return this;
    }

    public JmsEndpointBuilder durableSubscriberName(String durableSubscriberName) {
        this.endpoint.getEndpointConfiguration().setDurableSubscriberName(durableSubscriberName);
        return this;
    }

    public JmsEndpointBuilder useObjectMessages(boolean useObjectMessages) {
        this.endpoint.getEndpointConfiguration().setUseObjectMessages(useObjectMessages);
        return this;
    }

    public JmsEndpointBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }
}

