/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint.resolver;

import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import java.util.Map;
import org.springframework.util.StringUtils;

public class DynamicDestinationNameResolver
implements EndpointUriResolver {
    public static final String DESTINATION_HEADER_NAME = "citrus_jms_destination_name";
    private String defaultDestinationName;

    public String resolveEndpointUri(Message message, String defaultName) {
        Map headers = message.getHeaders();
        String destinationName = headers.containsKey(DESTINATION_HEADER_NAME) ? headers.get(DESTINATION_HEADER_NAME).toString() : (StringUtils.hasText((String)defaultName) ? defaultName : this.defaultDestinationName);
        if (destinationName == null) {
            throw new CitrusRuntimeException("Unable to resolve dynamic destination name! Neither header entry 'citrus_jms_destination_name' nor default destination name is set");
        }
        return destinationName;
    }

    public String getDefaultDestinationName() {
        return this.defaultDestinationName;
    }

    public void setDefaultDestinationName(String defaultDestinationName) {
        this.defaultDestinationName = defaultDestinationName;
    }
}

