/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.junit.jupiter.CitrusExtensionHelper;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class CitrusExtension
implements BeforeAllCallback,
BeforeEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver,
TestInstancePostProcessor,
TestExecutionExceptionHandler {
    private static final String SUITE_NAME = "citrus-junit5-suite";
    private static Citrus citrus;
    private static boolean beforeSuite;
    private static boolean afterSuite;
    public static final ExtensionContext.Namespace NAMESPACE;

    public void beforeAll(ExtensionContext extensionContext) {
        if (CitrusExtensionHelper.requiresCitrus(extensionContext)) {
            CitrusExtensionHelper.setCitrus(this.getCitrus(), extensionContext);
        } else {
            citrus = CitrusExtensionHelper.getCitrus(extensionContext);
        }
        if (beforeSuite) {
            beforeSuite = false;
            CitrusExtensionHelper.getCitrus(extensionContext).beforeSuite(SUITE_NAME, new String[0]);
        }
        if (afterSuite) {
            afterSuite = false;
            Runtime.getRuntime().addShutdownHook(new Thread(() -> CitrusExtensionHelper.getCitrus(extensionContext).afterSuite(SUITE_NAME, new String[0])));
        }
    }

    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        if (!CitrusExtensionHelper.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            TestCase testCase = CitrusExtensionHelper.getTestCase(extensionContext);
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)throwable));
        }
        throw throwable;
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestContext.class.getSimpleName()));
        extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCase.class.getSimpleName()));
    }

    public void beforeTestExecution(ExtensionContext extensionContext) {
        TestCaseRunner testRunner = CitrusExtensionHelper.getTestRunner(extensionContext);
        CitrusAnnotations.injectTestRunner((Object)extensionContext.getRequiredTestInstance(), (TestCaseRunner)testRunner);
        CitrusAnnotations.injectTestContext((Object)extensionContext.getRequiredTestInstance(), (TestContext)CitrusExtensionHelper.getTestContext(extensionContext));
        CitrusAnnotations.injectEndpoints((Object)extensionContext.getRequiredTestInstance(), (TestContext)CitrusExtensionHelper.getTestContext(extensionContext));
    }

    public void beforeEach(ExtensionContext extensionContext) {
        CitrusExtensionHelper.getTestContext(extensionContext);
        TestCase testCase = CitrusExtensionHelper.getTestCase(extensionContext);
        TestCaseRunner testRunner = CitrusExtensionHelper.getTestRunner(extensionContext);
        try {
            testRunner.start();
        }
        catch (AssertionError | Exception e) {
            CitrusExtensionHelper.getTestCase(extensionContext).setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
            throw new TestCaseFailedException((Throwable)e);
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        CitrusAnnotations.injectCitrusFramework((Object)testInstance, (Citrus)CitrusExtensionHelper.getCitrus(extensionContext));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().isAnnotationPresent(CitrusResource.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return CitrusExtensionHelper.resolveParameter(parameterContext, extensionContext);
    }

    protected Citrus getCitrus() {
        if (citrus == null) {
            citrus = Citrus.newInstance();
        }
        return citrus;
    }

    static {
        beforeSuite = true;
        afterSuite = true;
        NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CitrusExtension.class});
    }
}

