/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter;

import com.consol.citrus.Citrus;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.junit.jupiter.CitrusExtension;
import com.consol.citrus.junit.jupiter.spring.XmlTestHelper;
import java.lang.reflect.Method;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class CitrusExtensionHelper {
    private CitrusExtensionHelper() {
    }

    public static boolean isXmlTestMethod(Method method) {
        return method.isAnnotationPresent(CitrusXmlTest.class) || method.isAnnotationPresent(TestFactory.class);
    }

    public static TestCaseRunner createTestRunner(String testName, ExtensionContext extensionContext) {
        DefaultTestCaseRunner testCaseRunner = new DefaultTestCaseRunner((TestCase)new DefaultTestCase(), CitrusExtensionHelper.getTestContext(extensionContext));
        testCaseRunner.testClass(extensionContext.getRequiredTestClass());
        testCaseRunner.name(testName);
        testCaseRunner.packageName(extensionContext.getRequiredTestClass().getPackage().getName());
        return testCaseRunner;
    }

    public static TestCaseRunner getTestRunner(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCaseRunner)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCaseRunner.class.getSimpleName()), key -> {
            CitrusTest citrusTestAnnotation;
            Object testName = extensionContext.getRequiredTestClass().getSimpleName() + "." + extensionContext.getRequiredTestMethod().getName();
            if (extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class) != null && StringUtils.hasText((String)(citrusTestAnnotation = extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class)).name())) {
                testName = citrusTestAnnotation.name();
            }
            return CitrusExtensionHelper.createTestRunner((String)testName, extensionContext);
        }, TestCaseRunner.class);
    }

    public static TestCase getTestCase(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCase)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCase.class.getSimpleName()), key -> {
            if (CitrusExtensionHelper.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
                return XmlTestHelper.getXmlTestCase(extensionContext);
            }
            return CitrusExtensionHelper.getTestRunner(extensionContext).getTestCase();
        }, TestCase.class);
    }

    public static TestContext getTestContext(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestContext)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestContext.class.getSimpleName()), key -> CitrusExtensionHelper.getCitrus(extensionContext).getCitrusContext().createTestContext(), TestContext.class);
    }

    public static String getBaseKey(ExtensionContext extensionContext) {
        return extensionContext.getRequiredTestClass().getName() + "." + extensionContext.getRequiredTestMethod().getName() + "#";
    }

    public static Citrus getCitrus(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        Citrus citrus = (Citrus)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).get((Object)Citrus.class.getName(), Citrus.class);
        if (citrus == null) {
            throw new CitrusRuntimeException("Missing Citrus instance in JUnit5 extension context");
        }
        return citrus;
    }

    public static void setCitrus(Citrus citrus, ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).put((Object)Citrus.class.getName(), (Object)citrus);
    }

    public static Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        TestCaseRunner storedBuilder = CitrusExtensionHelper.getTestRunner(extensionContext);
        if (TestCaseRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return storedBuilder;
        }
        if (GherkinTestActionRunner.class.isAssignableFrom(parameterContext.getParameter().getType()) && storedBuilder instanceof GherkinTestActionRunner) {
            return storedBuilder;
        }
        if (TestActionRunner.class.isAssignableFrom(parameterContext.getParameter().getType()) && storedBuilder instanceof TestActionRunner) {
            return storedBuilder;
        }
        if (TestContext.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return CitrusExtensionHelper.getTestContext(extensionContext);
        }
        throw new CitrusRuntimeException(String.format("Failed to resolve parameter %s", parameterContext.getParameter()));
    }

    public static boolean requiresCitrus(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        Citrus citrus = (Citrus)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).get((Object)Citrus.class.getName(), Citrus.class);
        return citrus == null;
    }
}

