/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter.spring;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusInstanceManager;
import com.consol.citrus.CitrusSettings;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.common.XmlTestLoader;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.junit.jupiter.CitrusExtension;
import com.consol.citrus.junit.jupiter.CitrusExtensionHelper;
import com.consol.citrus.junit.jupiter.spring.XmlTestHelper;
import com.consol.citrus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class CitrusSpringExtension
implements BeforeAllCallback,
BeforeEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver,
TestInstancePostProcessor,
TestExecutionExceptionHandler {
    private Citrus citrus;
    private ApplicationContext applicationContext;
    private final CitrusExtension delegate = new CitrusExtension();

    public void beforeAll(ExtensionContext extensionContext) {
        CitrusExtensionHelper.setCitrus(this.getCitrus(extensionContext), extensionContext);
        this.delegate.beforeAll(extensionContext);
    }

    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        this.delegate.handleTestExecutionException(extensionContext, throwable);
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        if (!CitrusExtensionHelper.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            TestCase testCase = CitrusExtensionHelper.getTestCase(extensionContext);
            extensionContext.getExecutionException().ifPresent(e -> testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e)));
            CitrusExtensionHelper.getTestRunner(extensionContext).stop();
            extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCaseRunner.class.getSimpleName()));
        }
        this.delegate.afterTestExecution(extensionContext);
    }

    public void beforeTestExecution(ExtensionContext extensionContext) {
        CitrusExtensionHelper.setCitrus(this.getCitrus(extensionContext), extensionContext);
        if (CitrusExtensionHelper.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            CitrusExtensionHelper.getCitrus(extensionContext).run((TestAction)XmlTestHelper.getXmlTestCase(extensionContext), CitrusExtensionHelper.getTestContext(extensionContext));
        } else {
            this.delegate.beforeTestExecution(extensionContext);
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        if (CitrusExtensionHelper.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            CitrusExtensionHelper.getTestContext(extensionContext);
            XmlTestHelper.getXmlTestCase(extensionContext);
        } else {
            this.delegate.beforeEach(extensionContext);
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        this.delegate.postProcessTestInstance(testInstance, extensionContext);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.delegate.supportsParameter(parameterContext, extensionContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.delegate.resolveParameter(parameterContext, extensionContext);
    }

    protected Citrus getCitrus(ExtensionContext extensionContext) {
        ApplicationContext ctx = SpringExtension.getApplicationContext((ExtensionContext)extensionContext);
        if (this.applicationContext == null) {
            this.applicationContext = ctx;
            this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)ctx));
        } else if (!this.applicationContext.equals(ctx)) {
            this.applicationContext = ctx;
            this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)ctx));
        }
        return this.citrus;
    }

    public static Stream<DynamicTest> packageScan(String ... packagesToScan) {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        for (String packageScan : packagesToScan) {
            try {
                for (String fileNamePattern : CitrusSettings.getXmlTestFileNamePattern()) {
                    Resource[] fileResources;
                    for (Resource fileResource : fileResources = new PathMatchingResourcePatternResolver().getResources(packageScan.replace('.', File.separatorChar) + fileNamePattern)) {
                        Object filePath = fileResource.getFile().getParentFile().getCanonicalPath();
                        if (packageScan.startsWith("file:")) {
                            filePath = "file:" + (String)filePath;
                        }
                        filePath = ((String)filePath).substring(((String)filePath).indexOf(packageScan.replace('.', File.separatorChar)));
                        String testName = FileUtils.getBaseName((String)fileResource.getFilename());
                        XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, (String)filePath, CitrusInstanceManager.getOrDefault().getCitrusContext());
                        tests.add(DynamicTest.dynamicTest((String)testName, () -> CitrusInstanceManager.getOrDefault().run((TestAction)testLoader.load())));
                    }
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Unable to locate file resources for test package '" + packageScan + "'", (Throwable)e);
            }
        }
        return tests.stream();
    }

    public static Stream<DynamicTest> dynamicTests(String packageName, String ... testNames) {
        return Stream.of(testNames).map(testName -> {
            XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, packageName, CitrusInstanceManager.getOrDefault().getCitrusContext());
            return DynamicTest.dynamicTest((String)testName, () -> CitrusInstanceManager.getOrDefault().run((TestAction)testLoader.load()));
        });
    }

    public static Stream<DynamicTest> dynamicTests(Class<?> testClass, String ... testNames) {
        return Stream.of(testNames).map(testName -> {
            XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, testClass.getPackage().getName(), CitrusInstanceManager.getOrDefault().getCitrusContext());
            return DynamicTest.dynamicTest((String)testName, () -> CitrusInstanceManager.getOrDefault().run((TestAction)testLoader.load()));
        });
    }

    public static DynamicTest dynamicTest(String packageName, String testName) {
        XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, packageName, CitrusInstanceManager.getOrDefault().getCitrusContext());
        return DynamicTest.dynamicTest((String)testName, () -> CitrusInstanceManager.getOrDefault().run((TestAction)testLoader.load()));
    }
}

