/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node.locate;

import com.couchbase.client.core.ReplicaNotAvailableException;
import com.couchbase.client.core.ReplicaNotConfiguredException;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ObserveSeqnoRequest;
import com.couchbase.client.core.message.kv.ReplicaGetRequest;
import com.couchbase.client.core.message.kv.StatRequest;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.locate.Locator;
import com.couchbase.client.core.state.LifecycleState;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.SortedMap;
import java.util.zip.CRC32;

public class KeyValueLocator
implements Locator {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueLocator.class);
    private static final Node[] EMPTY_NODES = new Node[0];

    @Override
    public Node[] locate(CouchbaseRequest request, Set<Node> nodes, ClusterConfig cluster) {
        if (request instanceof GetBucketConfigRequest) {
            return KeyValueLocator.handleBucketConfigRequest((GetBucketConfigRequest)request, nodes);
        }
        if (request instanceof StatRequest) {
            return KeyValueLocator.handleStatRequest((StatRequest)request, nodes);
        }
        BucketConfig bucket = cluster.bucketConfig(request.bucket());
        if (bucket instanceof CouchbaseBucketConfig) {
            return KeyValueLocator.locateForCouchbaseBucket((BinaryRequest)request, nodes, (CouchbaseBucketConfig)bucket);
        }
        if (bucket instanceof MemcachedBucketConfig) {
            return KeyValueLocator.locateForMemcacheBucket((BinaryRequest)request, nodes, (MemcachedBucketConfig)bucket);
        }
        throw new IllegalStateException("Unsupported Bucket Type: " + bucket + " for request " + request);
    }

    private static Node[] handleBucketConfigRequest(GetBucketConfigRequest request, Set<Node> nodes) {
        return KeyValueLocator.locateByHostname(request.hostname(), nodes);
    }

    private static Node[] handleStatRequest(StatRequest request, Set<Node> nodes) {
        return KeyValueLocator.locateByHostname(request.hostname(), nodes);
    }

    private static Node[] locateByHostname(InetAddress hostname, Set<Node> nodes) {
        for (Node node : nodes) {
            if (!node.isState(LifecycleState.CONNECTED) || !hostname.equals(node.hostname())) continue;
            return new Node[]{node};
        }
        return EMPTY_NODES;
    }

    private static Node[] locateForCouchbaseBucket(BinaryRequest request, Set<Node> nodes, CouchbaseBucketConfig config) {
        int partitionId = KeyValueLocator.partitionForKey(request.keyBytes(), config.numberOfPartitions());
        request.partition((short)partitionId);
        int nodeId = KeyValueLocator.calculateNodeId(partitionId, request, config);
        if (nodeId < 0) {
            return KeyValueLocator.errorObservables(nodeId, request, config.name());
        }
        NodeInfo nodeInfo = config.nodeAtIndex(nodeId);
        for (Node node : nodes) {
            if (!node.hostname().equals(nodeInfo.hostname())) continue;
            return new Node[]{node};
        }
        if (config.nodes().size() != nodes.size()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Node list and configuration's partition hosts sizes : {} <> {}, rescheduling", (Object)nodes.size(), (Object)config.nodes().size());
            }
            return EMPTY_NODES;
        }
        throw new IllegalStateException("Node not found for request" + request);
    }

    private static int calculateNodeId(int partitionId, BinaryRequest request, CouchbaseBucketConfig config) {
        if (request instanceof ReplicaGetRequest) {
            return config.nodeIndexForReplica(partitionId, ((ReplicaGetRequest)request).replica() - 1);
        }
        if (request instanceof ObserveRequest && ((ObserveRequest)request).replica() > 0) {
            return config.nodeIndexForReplica(partitionId, ((ObserveRequest)request).replica() - 1);
        }
        if (request instanceof ObserveSeqnoRequest && ((ObserveSeqnoRequest)request).replica() > 0) {
            return config.nodeIndexForReplica(partitionId, ((ObserveSeqnoRequest)request).replica() - 1);
        }
        return config.nodeIndexForMaster(partitionId);
    }

    private static Node[] errorObservables(int nodeId, BinaryRequest request, String name) {
        if (nodeId == -2) {
            if (request instanceof ReplicaGetRequest) {
                request.observable().onError((Throwable)new ReplicaNotConfiguredException("Replica number " + ((ReplicaGetRequest)request).replica() + " not configured for bucket " + name));
            } else if (request instanceof ObserveRequest) {
                request.observable().onError((Throwable)new ReplicaNotConfiguredException("Replica number " + ((ObserveRequest)request).replica() + " not configured for bucket " + name));
            } else if (request instanceof ObserveSeqnoRequest) {
                request.observable().onError((Throwable)new ReplicaNotConfiguredException("Replica number " + ((ObserveSeqnoRequest)request).replica() + " not configured for bucket " + name));
            }
            return null;
        }
        if (nodeId == -1) {
            if (request instanceof ObserveRequest) {
                request.observable().onError((Throwable)new ReplicaNotAvailableException("Replica number " + ((ObserveRequest)request).replica() + " not available for bucket " + name));
                return null;
            }
            if (request instanceof ReplicaGetRequest) {
                request.observable().onError((Throwable)new ReplicaNotAvailableException("Replica number " + ((ReplicaGetRequest)request).replica() + " not available for bucket " + name));
                return null;
            }
            if (request instanceof ObserveSeqnoRequest) {
                request.observable().onError((Throwable)new ReplicaNotAvailableException("Replica number " + ((ObserveSeqnoRequest)request).replica() + " not available for bucket " + name));
                return null;
            }
            return EMPTY_NODES;
        }
        return EMPTY_NODES;
    }

    private static int partitionForKey(byte[] key, int numPartitions) {
        CRC32 crc32 = new CRC32();
        crc32.update(key);
        long rv = crc32.getValue() >> 16 & 0x7FFFL;
        return (int)rv & numPartitions - 1;
    }

    private static Node[] locateForMemcacheBucket(BinaryRequest request, Set<Node> nodes, MemcachedBucketConfig config) {
        long hash = KeyValueLocator.calculateKetamaHash(request.keyBytes());
        if (!config.ketamaNodes().containsKey(hash)) {
            SortedMap<Long, NodeInfo> tailMap = config.ketamaNodes().tailMap(hash);
            hash = tailMap.isEmpty() ? config.ketamaNodes().firstKey().longValue() : tailMap.firstKey().longValue();
        }
        NodeInfo found = (NodeInfo)config.ketamaNodes().get(hash);
        request.partition((short)0);
        for (Node node : nodes) {
            if (!node.hostname().equals(found.hostname())) continue;
            return new Node[]{node};
        }
        if (config.nodes().size() != nodes.size()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Node list and configuration's partition hosts sizes : {} <> {}, rescheduling", (Object)nodes.size(), (Object)config.nodes().size());
            }
            return EMPTY_NODES;
        }
        throw new IllegalStateException("Node not found for request" + request);
    }

    private static long calculateKetamaHash(byte[] key) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(key);
            byte[] digest = md5.digest();
            long rv = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
            return rv & 0xFFFFFFFFL;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not encode ketama hash.", e);
        }
    }
}

