/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.LoaderType;
import com.couchbase.client.core.config.loader.AbstractLoader;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.config.BucketConfigRequest;
import com.couchbase.client.core.message.config.BucketConfigResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.NetworkAddress;
import rx.Observable;
import rx.functions.Func1;

public class HttpLoader
extends AbstractLoader {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(HttpLoader.class);
    private static final String TERSE_PATH = "/pools/default/b/";
    private static final String VERBOSE_PATH = "/pools/default/buckets/";

    public HttpLoader(ClusterFacade cluster, CoreEnvironment environment) {
        super(LoaderType.HTTP, ServiceType.CONFIG, cluster, environment);
    }

    @Override
    protected int port() {
        return this.env().sslEnabled() ? this.env().bootstrapHttpSslPort() : this.env().bootstrapHttpDirectPort();
    }

    @Override
    protected Observable<String> discoverConfig(final String bucket, final String username, final String password, final NetworkAddress hostname) {
        if (!this.env().bootstrapHttpEnabled()) {
            LOGGER.info("HTTP Bootstrap manually disabled.");
            return Observable.error((Throwable)new ConfigurationException("HTTP Bootstrap disabled through configuration."));
        }
        LOGGER.debug("Starting to discover config through HTTP Bootstrap");
        return this.cluster().send(new BucketConfigRequest(TERSE_PATH, hostname, username, bucket, password)).flatMap((Func1)new Func1<BucketConfigResponse, Observable<BucketConfigResponse>>(){

            public Observable<BucketConfigResponse> call(BucketConfigResponse response) {
                if (response.status().isSuccess()) {
                    LOGGER.debug("Successfully got config from terse bucket remote.");
                    return Observable.just((Object)response);
                }
                LOGGER.debug("Terse bucket config failed, falling back to verbose.");
                return HttpLoader.this.cluster().send(new BucketConfigRequest(HttpLoader.VERBOSE_PATH, hostname, bucket, username, password));
            }
        }).map((Func1)new Func1<BucketConfigResponse, String>(){

            public String call(BucketConfigResponse response) {
                if (!response.status().isSuccess()) {
                    throw new IllegalStateException("Could not load bucket configuration: " + (Object)((Object)response.status()) + "(" + response.config() + ")");
                }
                LOGGER.debug("Successfully loaded config through HTTP.");
                return HttpLoader.this.replaceHostWildcard(response.config(), hostname);
            }
        });
    }
}

