/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.metrics;

import com.couchbase.client.core.metrics.LatencyMetricsIdentifier;

public class NetworkLatencyMetricsIdentifier
implements LatencyMetricsIdentifier {
    private final String host;
    private final String service;
    private final String request;
    private final String status;

    public NetworkLatencyMetricsIdentifier(String host, String service, String request, String status) {
        this.host = host;
        this.service = service;
        this.request = request;
        this.status = status;
    }

    public String host() {
        return this.host;
    }

    public String service() {
        return this.service;
    }

    public String request() {
        return this.request;
    }

    public String status() {
        return this.status;
    }

    @Override
    public int compareTo(LatencyMetricsIdentifier o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return this.host + "->" + this.service + "->" + this.request + "->" + this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkLatencyMetricsIdentifier that = (NetworkLatencyMetricsIdentifier)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        return !(this.status == null ? that.status != null : !this.status.equals(that.status));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
        result = 31 * result + (this.request != null ? this.request.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }
}

