/*
 * Copyright (c) 2019 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.couchbase.client.core.msg.analytics;

import com.couchbase.client.core.msg.BaseResponse;
import com.couchbase.client.core.msg.ResponseStatus;

public class AnalyticsPingResponse extends BaseResponse {

  private final byte[] content;
  private final String channelId;

  AnalyticsPingResponse(ResponseStatus status, byte[] content, String channelId) {
    super(status);
    this.content = content;
    this.channelId = channelId;
  }

  public byte[] content() {
    return content;
  }

  public String channelId() {
    return channelId;
  }
}
