/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.manager.search;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.CbCollections;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Stability.Internal
@JsonIgnoreProperties(ignoreUnknown=true)
public class CoreSearchIndex {
    private final String name;
    private final String sourceName;
    private String uuid;
    private String type;
    private Map<String, Object> params;
    private String sourceUuid;
    private Map<String, Object> sourceParams;
    private String sourceType;
    private Map<String, Object> planParams;

    public CoreSearchIndex(String name, String sourceName) {
        this.name = name;
        this.sourceName = sourceName;
    }

    @JsonCreator
    public CoreSearchIndex(@JsonProperty(value="uuid") String uuid, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="params") Map<String, Object> params, @JsonProperty(value="sourceUUID") String sourceUuid, @JsonProperty(value="sourceName") String sourceName, @JsonProperty(value="sourceParams") Map<String, Object> sourceParams, @JsonProperty(value="sourceType") String sourceType, @JsonProperty(value="planParams") Map<String, Object> planParams) {
        this.uuid = uuid;
        this.name = name;
        this.sourceName = sourceName;
        this.type = type;
        this.params = params;
        this.sourceUuid = sourceUuid;
        this.sourceParams = sourceParams;
        this.sourceType = sourceType;
        this.planParams = planParams;
    }

    public static CoreSearchIndex fromJson(String input) {
        try {
            return Mapper.decodeInto(input, CoreSearchIndex.class);
        }
        catch (Exception ex) {
            throw InvalidArgumentException.fromMessage("Could not decode search index JSON", ex);
        }
    }

    public String name() {
        return this.name;
    }

    public String uuid() {
        return this.uuid;
    }

    public CoreSearchIndex uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public CoreSearchIndex unsetUuid() {
        this.uuid = null;
        return this;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public String type() {
        return this.type;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public CoreSearchIndex params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public String sourceUuid() {
        return this.sourceUuid;
    }

    public CoreSearchIndex sourceUuid(String sourceUuid) {
        this.sourceUuid = sourceUuid;
        return this;
    }

    public Map<String, Object> sourceParams() {
        return this.sourceParams;
    }

    public CoreSearchIndex sourceParams(Map<String, Object> sourceParams) {
        this.sourceParams = sourceParams;
        return this;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public CoreSearchIndex sourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public Map<String, Object> planParams() {
        return this.planParams;
    }

    public CoreSearchIndex planParams(Map<String, Object> planParams) {
        this.planParams = planParams;
        return this;
    }

    public String toJson() {
        HashMap<String, Object> output = new HashMap<String, Object>();
        if (this.uuid != null) {
            output.put("uuid", this.uuid);
        }
        output.put("name", this.name);
        output.put("sourceName", this.sourceName);
        output.put("type", this.type == null ? "fulltext-index" : this.type);
        output.put("sourceType", this.sourceType == null ? "couchbase" : this.sourceType);
        if (!CbCollections.isNullOrEmpty(this.params)) {
            output.put("params", this.params);
        }
        if (!CbCollections.isNullOrEmpty(this.planParams)) {
            output.put("planParams", this.planParams);
        }
        if (!CbCollections.isNullOrEmpty(this.sourceParams)) {
            output.put("sourceParams", this.sourceParams);
        }
        if (this.sourceUuid != null) {
            output.put("sourceUUID", this.sourceUuid);
        }
        return Mapper.encodeAsString(output);
    }

    boolean containsVectorMappings() {
        JsonNode types;
        JsonNode mapping;
        JsonNode params;
        JsonNode json = Mapper.decodeIntoTree(this.toJson().getBytes(StandardCharsets.UTF_8));
        if (json.has("params") && (params = json.get("params")).isObject() && params.has("mapping") && (mapping = params.get("mapping")).isObject() && mapping.has("types") && (types = mapping.get("types")).isObject()) {
            Iterator<String> typesFieldNames = types.fieldNames();
            while (typesFieldNames.hasNext()) {
                String typesFieldName = typesFieldNames.next();
                JsonNode type = types.get(typesFieldName);
                if (!type.isObject() || !type.has("properties")) continue;
                JsonNode properties = type.get("properties");
                Iterator<String> propertiesFieldNames = properties.fieldNames();
                while (propertiesFieldNames.hasNext()) {
                    JsonNode fields;
                    String propertiesFieldName = propertiesFieldNames.next();
                    JsonNode property = properties.get(propertiesFieldName);
                    if (!property.has("fields") || !(fields = property.get("fields")).isArray()) continue;
                    ArrayNode fieldsArray = (ArrayNode)fields;
                    for (int i = 0; i < fieldsArray.size(); ++i) {
                        JsonNode typ;
                        JsonNode field = fieldsArray.get(i);
                        if (!field.has("type") || !(typ = field.get("type")).isTextual() || !typ.textValue().startsWith("vector")) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public String toString() {
        return "CoreSearchIndex{uuid='" + this.uuid + '\'' + ", name='" + this.name + '\'' + ", sourceName='" + this.sourceName + '\'' + ", type='" + this.type + '\'' + ", params=" + this.params + ", sourceUuid='" + this.sourceUuid + '\'' + ", sourceParams=" + this.sourceParams + ", sourceType='" + this.sourceType + '\'' + ", planParams=" + this.planParams + '}';
    }
}

