/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.vector;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Either;
import com.couchbase.client.core.util.Validators;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreVector {
    private final Either<float[], String> floatsOrBase64;

    public static CoreVector of(float[] floats) {
        return CoreVector.eitherOf(floats, null);
    }

    public static CoreVector of(String base642) {
        return CoreVector.eitherOf(null, base642);
    }

    public static CoreVector eitherOf(@Nullable float[] floats, @Nullable String base64Encoded) {
        return new CoreVector(Either.of(floats, base64Encoded));
    }

    private CoreVector(Either<float[], String> floatsOrBase64) {
        this.floatsOrBase64 = Objects.requireNonNull(floatsOrBase64);
        floatsOrBase64.ifPresent(floats -> {
            if (((float[])floats).length == 0) {
                throw InvalidArgumentException.fromMessage("Vector must have at least one element.");
            }
        }, base642 -> Validators.notNullOrEmpty(base642, "base64EncodedVector"));
    }

    public void writeTo(ObjectNode parent) {
        this.floatsOrBase64.ifPresent(floats -> {
            ArrayNode array = Mapper.createArrayNode();
            for (float f : floats) {
                array.add(f);
            }
            parent.set("vector", array);
        }, base64Encoded -> parent.put("vector_base64", (String)base64Encoded));
    }
}

