/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.config;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import java.time.Duration;
import java.util.Optional;

public class ConfigIgnoredEvent
extends AbstractEvent {
    private final Optional<String> config;
    private final Reason reason;
    private final Optional<Exception> cause;
    private final Optional<String> bucketName;

    public ConfigIgnoredEvent(Context context, Reason reason, Optional<Exception> cause, Optional<String> config, Optional<String> bucketName) {
        super(reason.severity(), Event.Category.CONFIG, Duration.ZERO, context);
        this.reason = reason;
        this.cause = cause;
        this.config = config;
        this.bucketName = bucketName;
    }

    public Reason reason() {
        return this.reason;
    }

    @Override
    public Exception cause() {
        return this.cause.orElse(null);
    }

    public Optional<String> config() {
        return this.config;
    }

    @Override
    public String description() {
        String msg = "The proposed configuration (" + this.bucketName.orElse("<global>") + ") was ignored because of: " + (Object)((Object)this.reason());
        if (this.reason == Reason.PARSE_FAILURE && this.config.isPresent()) {
            msg = msg + "; Config: " + this.config.get();
        }
        if (this.cause.isPresent()) {
            msg = msg + "; Cause: " + this.cause.get().getMessage();
        }
        return msg;
    }

    public static enum Reason {
        OLD_OR_SAME_REVISION(Event.Severity.VERBOSE),
        ALREADY_SHUTDOWN(Event.Severity.VERBOSE),
        PARSE_FAILURE(Event.Severity.WARN);

        private final Event.Severity severity;

        private Reason(Event.Severity severity) {
            this.severity = severity;
        }

        public Event.Severity severity() {
            return this.severity;
        }
    }
}

