/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.compression.snappy;

import com.couchbase.client.core.compression.snappy.FastSnappyCodec;
import com.couchbase.client.core.compression.snappy.SlowSnappyCodec;
import com.couchbase.client.core.compression.snappy.SnappyCodec;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SnappyHelper {
    private static final Logger log = LoggerFactory.getLogger(SnappyHelper.class);
    static final SnappyCodec INSTANCE = SnappyHelper.createSuitableInstance();

    SnappyHelper() {
    }

    private static SnappyCodec createSuitableInstance() {
        if (!SnappyHelper.compatibleByteOrder()) {
            log.info("Using slower Snappy compression codec because this is big-endian hardware.");
            return new SlowSnappyCodec();
        }
        if (!SnappyHelper.canAccessUnsafe()) {
            log.info("Using slower Snappy compression codec because `sun.misc.Unsafe` is absent from this JVM, or not accessible in this security context.");
            return new SlowSnappyCodec();
        }
        log.info("Using fast Snappy compression codec because this is little-endian hardware and `sun.misc.Unsafe` is accessible.");
        return new FastSnappyCodec();
    }

    private static boolean compatibleByteOrder() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    }

    private static boolean canAccessUnsafe() {
        try {
            Field theUnsafe = SnappyCodec.class.getClassLoader().loadClass("sun.misc.Unsafe").getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Object ignored = theUnsafe.get(null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

