/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.endpoint.AnalyticsEndpoint;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.service.AnalyticsServiceConfig;
import com.couchbase.client.core.service.EndpointSelectionStrategy;
import com.couchbase.client.core.service.PooledService;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.service.strategy.RoundRobinSelectionStrategy;
import java.util.Optional;

public class AnalyticsService
extends PooledService {
    private final String hostname;
    private final int port;

    public AnalyticsService(AnalyticsServiceConfig config, CoreContext context, String hostname, int port) {
        super(config, new ServiceContext(context, hostname, port, ServiceType.ANALYTICS, Optional.empty()));
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    protected Endpoint createEndpoint() {
        return new AnalyticsEndpoint(this.serviceContext(), this.hostname, this.port);
    }

    @Override
    protected EndpointSelectionStrategy selectionStrategy() {
        return new RoundRobinSelectionStrategy();
    }

    @Override
    public ServiceType type() {
        return ServiceType.ANALYTICS;
    }
}

