/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbThrowables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Stability.Internal
public class CbPreconditions {
    private static final Pattern PLACEHOLDER = Pattern.compile(Pattern.quote("{}"));

    private CbPreconditions() {
    }

    public static void check(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static void check(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void check(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(CbPreconditions.format(message, args));
        }
    }

    private static String format(String message, Object ... args) {
        Object lastExtraArg;
        if (args.length == 0) {
            return message;
        }
        Iterator<Object> i = Arrays.asList(args).iterator();
        Matcher m = PLACEHOLDER.matcher(message);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String replacement = i.hasNext() ? String.valueOf(i.next()) : "{}";
            m.appendReplacement(result, replacement);
        }
        m.appendTail(result);
        if (i.hasNext() && (lastExtraArg = args[args.length - 1]) instanceof Throwable) {
            result.append("\n").append(CbThrowables.getStackTraceAsString((Throwable)lastExtraArg));
        }
        return result.toString();
    }
}

