/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import java.util.Objects;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.util.annotation.NonNull;

@Stability.Internal
public class LatestStateSubscription<T> {
    private final Sinks.One<Void> terminationSignal = Sinks.one();
    private final Scheduler scheduler;
    private final AsyncSubscriber<T> subscriber;
    private final Object lock = new Object();
    private boolean upstreamTerminated;
    private boolean processingInProgress;
    private T deferredValue;

    public LatestStateSubscription(Flux<T> flux, Scheduler scheduler, AsyncSubscriber<T> subscriber) {
        this.scheduler = Objects.requireNonNull(scheduler);
        this.subscriber = Objects.requireNonNull(subscriber);
        flux.onBackpressureLatest().publishOn(scheduler).subscribe((CoreSubscriber)new BaseSubscriber<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void hookOnNext(@NonNull T value) {
                Object object = LatestStateSubscription.this.lock;
                synchronized (object) {
                    if (LatestStateSubscription.this.processingInProgress) {
                        LatestStateSubscription.this.deferredValue = value;
                        return;
                    }
                    LatestStateSubscription.this.process(value);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void hookFinally(@NonNull SignalType type) {
                Object object = LatestStateSubscription.this.lock;
                synchronized (object) {
                    LatestStateSubscription.this.upstreamTerminated = true;
                    if (!LatestStateSubscription.this.processingInProgress) {
                        LatestStateSubscription.this.terminationSignal.tryEmitEmpty().orThrow();
                    }
                }
            }
        });
    }

    private void process(T value) {
        this.processingInProgress = true;
        this.scheduler.schedule(() -> this.subscriber.hookOnNext(value, this::onFinishedProcessingValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinishedProcessingValue() {
        Object object = this.lock;
        synchronized (object) {
            if (this.deferredValue != null) {
                T value = this.deferredValue;
                this.deferredValue = null;
                this.process(value);
                return;
            }
            this.processingInProgress = false;
            if (this.upstreamTerminated) {
                this.terminationSignal.tryEmitEmpty().orThrow();
            }
        }
    }

    public Mono<Void> awaitTermination() {
        return this.terminationSignal.asMono();
    }

    @FunctionalInterface
    public static interface AsyncSubscriber<T> {
        public void hookOnNext(T var1, Runnable var2);
    }
}

