/*
 * Decompiled with CFR 0.152.
 */
package com.coveo;

import com.coveo.AbstractFMT;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class Check
extends AbstractFMT {
    @Parameter(defaultValue="true", property="displayFiles")
    private boolean displayFiles;
    @Parameter(defaultValue="100", property="displayLimit")
    private int displayLimit;
    private List<String> filesNotFormatted = new ArrayList<String>();

    @Override
    protected void postExecute(List<String> filesProcessed, int nonComplyingFiles) throws MojoFailureException {
        if (nonComplyingFiles > 0) {
            String message = "Found " + nonComplyingFiles + " non-complying files, failing build";
            this.getLog().error((CharSequence)message);
            this.getLog().error((CharSequence)"To fix formatting errors, run \"mvn fmt:format\"");
            this.displayLimit = Math.max(1, this.displayLimit);
            if (this.displayFiles) {
                for (String path : this.filesNotFormatted.subList(0, Math.min(this.displayLimit, this.filesNotFormatted.size()))) {
                    this.getLog().error((CharSequence)("Non complying file: " + path));
                }
                if (nonComplyingFiles > this.displayLimit) {
                    this.getLog().error((CharSequence)String.format("... and %d more files.", nonComplyingFiles - this.displayLimit));
                }
            }
            throw new MojoFailureException(message);
        }
    }

    @Override
    protected void onNonComplyingFile(File file, String formatted) throws IOException {
        this.filesNotFormatted.add(file.getAbsolutePath());
    }

    @Override
    protected String getProcessingLabel() {
        return "non-complying";
    }
}

