/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.saml;

import java.io.Writer;
import java.util.Map;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public class XMLHelper {
    public static void writeNode(Node node, Writer output) {
        XMLHelper.writeNode(node, output, null);
    }

    public static void writeNode(Node node, Writer output, Map<String, Object> serializerParams) {
        DOMImplementationLS domImplLS = XMLHelper.getLSDOMImpl(node);
        LSSerializer serializer = XMLHelper.getLSSerializer(domImplLS, serializerParams);
        LSOutput serializerOut = domImplLS.createLSOutput();
        serializerOut.setCharacterStream(output);
        serializer.write(node, serializerOut);
    }

    public static LSSerializer getLSSerializer(DOMImplementationLS domImplLS, Map<String, Object> serializerParams) {
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.setFilter(new LSSerializerFilter(){

            @Override
            public short acceptNode(Node arg0) {
                return 1;
            }

            @Override
            public int getWhatToShow() {
                return -1;
            }
        });
        if (serializerParams != null) {
            DOMConfiguration serializerDOMConfig = serializer.getDomConfig();
            for (String key : serializerParams.keySet()) {
                serializerDOMConfig.setParameter(key, serializerParams.get(key));
            }
        }
        return serializer;
    }

    public static DOMImplementationLS getLSDOMImpl(Node node) {
        DOMImplementation domImpl = node instanceof Document ? ((Document)node).getImplementation() : node.getOwnerDocument().getImplementation();
        DOMImplementationLS domImplLS = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
        return domImplLS;
    }
}

