/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.configuration.parameterstore;

import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.coveo.configuration.parameterstore.ParameterStorePropertySourceConfigurationProperties;
import com.coveo.configuration.parameterstore.strategy.ParameterStorePropertySourceConfigurationStrategy;
import com.coveo.configuration.parameterstore.strategy.ParameterStorePropertySourceConfigurationStrategyFactory;
import com.coveo.configuration.parameterstore.strategy.StrategyType;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ObjectUtils;

public class ParameterStorePropertySourceEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    static ParameterStorePropertySourceConfigurationStrategyFactory strategyFactory = new ParameterStorePropertySourceConfigurationStrategyFactory();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (this.isParameterStorePropertySourceEnabled(environment)) {
            this.getParameterStorePropertySourceConfigurationStrategy(environment).configureParameterStorePropertySources(environment, this.preconfigureSSMClientBuilder(environment));
        }
    }

    private AWSSimpleSystemsManagementClientBuilder preconfigureSSMClientBuilder(ConfigurableEnvironment environment) {
        return (AWSSimpleSystemsManagementClientBuilder)AWSSimpleSystemsManagementClientBuilder.standard().withClientConfiguration(new ClientConfigurationFactory().getConfig().withRetryPolicy(PredefinedRetryPolicies.getDefaultRetryPolicyWithCustomMaxRetries((int)((Integer)environment.getProperty(ParameterStorePropertySourceConfigurationProperties.MAX_ERROR_RETRY, Integer.class, (Object)3)))));
    }

    private ParameterStorePropertySourceConfigurationStrategy getParameterStorePropertySourceConfigurationStrategy(ConfigurableEnvironment environment) {
        StrategyType type = this.isMultiRegionEnabled(environment) ? StrategyType.MULTI_REGION : StrategyType.DEFAULT;
        return strategyFactory.getStrategy(type);
    }

    private boolean isParameterStorePropertySourceEnabled(ConfigurableEnvironment environment) {
        Object[] userDefinedEnabledProfiles = (String[])environment.getProperty(ParameterStorePropertySourceConfigurationProperties.ACCEPTED_PROFILES, String[].class);
        return (Boolean)environment.getProperty(ParameterStorePropertySourceConfigurationProperties.ENABLED, Boolean.class, (Object)Boolean.FALSE) != false || environment.acceptsProfiles(new String[]{"awsParameterStorePropertySourceEnabled"}) || !ObjectUtils.isEmpty((Object[])userDefinedEnabledProfiles) && environment.acceptsProfiles((String[])userDefinedEnabledProfiles);
    }

    private boolean isMultiRegionEnabled(ConfigurableEnvironment environment) {
        return environment.containsProperty(ParameterStorePropertySourceConfigurationProperties.MULTI_REGION_SSM_CLIENT_REGIONS);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

